#!/usr/bin/perl
##
my $revision = '$Id: sanitizer.pl,v 1.49 2002/02/15 16:59:49 bre Exp $';
my $version = 'Anomy 0.0.0 : sanitizer.pl';
#
##  Copyright (c) 2000-2002 Bjarni R. Einarsson. All rights reserved.
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
#
##############################################################################
#
# NOTE:  Sanitizer development is for the most part sponsored by
#        FRISK Software International, http://www.f-prot.com/.  Please
#        consider buying their anti-virus products to show your 
#        appreciation.
#
##############################################################################
#
# This is an email sanitizer.  Stick it in your .procmailrc!
# Implemented features:
#
#   + Minimal resource consumption (I hope).
#   + Can truncates all MIME headers to a reasonable length, to avoid 
#     buffer overflows in buggy mail readers.  Also attempts to protect
#     against overflows based on information parsed from other headers.
#   + Can renames attachments so they won't get auto-executed by naughty
#     mail readers.
#   + Defangs active HTML content.
#   + Can attach a log of what was done to the message (if anything
#     interesting was done, that is, and we can find a place to put
#     the log w/o breaking the message).
#   + Supports external virus scanners.
#   + Includes a crude built in scanner designed to guess whether macros in 
#     Microsoft documents are hostile or not.
#
# TODO:
#
#   + More flexible logging, e.g. by email, files or syslog.
#   + Allow rejection of messages, resulting in replies etc.
#
BEGIN { push @INC, $ENV{"ANOMY"} . "/bin" };
use strict;
use Anomy::Sanitizer;
use Anomy::Sanitizer::MacroScanner;

# Create new Sanitizer engine object.
my $engine = new Anomy::Sanitizer;
if (my $e = $engine->error())
{
    print STDERR $e;
    exit(1);
}

# Register John's Macro scanner as builtin/macro.
$engine->register_scanner("macro", \&MacroScanner);
if (my $e = $engine->error())
{
    print STDERR $e;
    exit(1);
}

# Macro scanner configuration - this doesn't make sense within the Sanitizer.pm
# module, since the Sanitizer.pm module knows nothing about the macro scanner.
my @MACROSCAN = ('file_list_5_scanner = 0:1:2:builtin/macro 25',
                 'file_list_5_policy  = unknown:mangle:mangle:defang',
                 'file_list_5 = (?i)\.(do[tc]|xl[aswct]|p[po]t|pps|rtf|md[abw])$');

# Configure engine using stuff on command line.
$engine->configure(@MACROSCAN, @ARGV);
if (my $e = $engine->error())
{
    print STDERR $engine->get_msg("usage"), "\n";
    print STDERR $engine->get_msg("current"), "\n";
    print STDERR $engine->get_config_text();
    print STDERR "\n", $e, "\n";
    exit(1);
}

# Go!
my $ret = $engine->sanitize(*STDIN, *STDOUT);
if (my $e = $engine->error())
{
    print STDERR $e;
}
exit($ret);

