\name{getuuid}
\alias{getuuid}
\title{Functions to handle unique IDs}
\description{
  These functions allow a user to retrieve and transform universally
  unique ID values.  A user can get a new UUID, as well as transform a string
  representation into a byte representation and vice versa.
}
\usage{
getuuid(cur)
}
\arguments{
  \item{cur}{If provided, either a UUID string or a \code{uuidt} object}
}
\details{
  This package uses Theodore Ts'o's libuuid to generate universally
  unique ID values.  A unique ID value is represented in R by the class
  \code{uuidt}, which wraps the byte values.  A wrapper object is the
  most common method of handling these values, \code{Ruuid} - which also
  provides for a string representation of the UUID.

  If no parameter \code{cur} is passed into \code{getuuid}, a new
  \code{Ruuid} is generated.  If either a string or a \code{uuidt}
  object is passed in, then the complementary piece is generated and the
  resultant \code{Ruuid} is generated.
}
\value{
  getuuid:  Returns an object of class \code{Ruuid}.
}
\references{ Theodore Ts'o's Universally Unique ID library\cr
  \url{http://web.mit.edu/tytso/www/home.html}}
\author{R. Gentleman and Jeff Gentry}
\seealso{\code{\link{Ruuid}}, \code{\link{uuidt}}}
\examples{
z <- getuuid()
z
a <- getuuid(stringRep(z))
a
q <- getuuid(uuid(z))
q
w <- getuuid()
w
}
\keyword{utilities}
