"seqaln" <-
function(aln, id=NULL,
                   exepath = "",
                   file = "aln.fa",
                   protein = TRUE,
                   seqgroup = FALSE,
                   refine = FALSE,
                   extra.args = "") {

  # extra.args = " -tree2 tree.out"

  as.aln <- function(mat, id=NULL) {
    if(is.null(id))
      id=paste("seq",1:nrow(mat),sep="")
    return(list(id=id, ali=mat))
  }

  if( (!is.list(aln)) | is.na(aln['id']) )
    aln<-as.aln(aln,id=id)


  os1   <- .Platform$OS.type
  toaln <- tempfile()  
  write.fasta(aln, file=toaln)
  
  if(!seqgroup)  extra.args <- paste(extra.args,"-stable")
  if(refine) extra.args <- paste(extra.args,"-refine")
  if(protein) {
    extra.args <- paste(extra.args,"-seqtype protein")
  } else { extra.args <- paste(extra.args,"-seqtype dna") }
  
  cmd <- paste(exepath, "muscle -in ",toaln," -out ",file, " ",extra.args, sep="")
  cat(cmd)
  
  if (os1 == "windows") {
    system(shQuote(cmd))
  } else {
    system(cmd)
  }
  unlink(toaln)
  return(read.fasta(file))
}

