
/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stddef.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <event.h>

#include <debug/log.h>

#include <abz/error.h>
#include <abz/typedefs.h>

#include "gui.h"
#include "signal.h"

static const int sigset_ignore[] = { SIGUSR1, SIGUSR2, SIGTSTP };
static const int sigset_accept[] = { SIGHUP, SIGINT, SIGTERM, SIGABRT };
static struct event events[ARRAYSIZE (sigset_accept)];

static void signal_event (int fd,short event,void *arg)
{
   int i;

   log_printf (LOG_ERROR,"caught signal %d\n",fd);

   for (i = 0; i < ARRAYSIZE (sigset_accept); i++)
	 signal_del (events + i);

   gui_close ();
}

void signal_open (void)
{
   int i;

   for (i = 0; i < ARRAYSIZE (sigset_ignore); i++)
	 signal (sigset_ignore[i],SIG_IGN);

   for (i = 0; i < ARRAYSIZE (sigset_accept); i++)
	 {
		signal_set (events + i,sigset_accept[i],signal_event,NULL);
		signal_add (events + i,NULL);
	 }
}

void signal_close (void)
{
   static volatile int called = 0;

   if (!called)
	 {
		int i;

		called = 1;

		for (i = 0; i < ARRAYSIZE (sigset_accept); i++)
		  {
			 signal_del (events + i);
			 signal (sigset_accept[i],SIG_DFL);
		  }

		for (i = 0; i < ARRAYSIZE (sigset_ignore); i++)
		  signal (sigset_ignore[i],SIG_DFL);
	 }
}

