/*
 * Copyright (c) 2000, Amnon BARAK (amnon@cs.huji.ac.il). All rights reserved.
 *
 *	MOSIX $Id: migrate.c,v 1.7 2001/03/06 01:32:32 amnons Exp $
 *
 * Permission to use, copy and distribute this software is hereby granted 
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Ariel Rosenblatt
 * Code based on previous work by Amnon Shiloh and Oren Laadan
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/signal.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <mos.h>

int main(int na, char *argv[])
{
	char *prog = (na && strchr(argv[0], '/')) ? strchr(argv[0], '/') + 1 :
							(na ? argv[0] : "");
	struct process_info a;


	if (!msx_is_mosix()) {
		fprintf(stderr, "migrate ignored: This is NOT a MOSIX system!\n");
		exit(1);
	}
	
	if(na != 3 || (a.pid = atoi(argv[1])) <= 0)
		goto Usage;
	switch(argv[2][0]) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		if((a.where = atoi(argv[2])) < 0)
			goto Usage;
		break;
	case 'h':
	case 'H':
		a.where = DM_GOBACKHOME;
		break;
	case 'b':
	case 'B':
		if (!msx_is_configured()) {
			fprintf(stderr, "%s: Balance requests meaningless when MOSIX is not configured\n", prog);
	    	}
		a.where = DM_BALANCE;
		break;
	default:
	Usage:
		printf("Usage: %s pid {MOSIX-ID|home|balance}\n", prog);
		exit(1);
	}
	if(msxctl2(D_SETWHERETO, (int)&a) == -1) {
		fprintf(stderr, "%s: ", prog);
		switch(errno)
		{
			case EPERM:
				fprintf(stderr, "Permission denied.\n");
				break;
			case EBUSY:
				fprintf(stderr, "Process was already sent elsewhere.\n");
				break;
			case ESRCH:
				fprintf(stderr, "No such process (%d).\n", a.pid);
				break;
			case EROFS:
				fprintf(stderr, "Process #%d is unmovable.\n",
					a.pid);
				break;
			default:
				fprintf(stderr, "%s.\n", sys_errlist[errno]);
		}
		return -1;
	}
	return 0;
}
