#include "mixer.h"

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

#define HARDWARE_VOLUME

#if defined(__osf__)
#undef HARDWARE_VOLUME
#elif defined(__linux__)
#include <sys/soundcard.h>
#elif defined(__FreeBSD__)
#include <sys/soundcard.h>
#elif defined(__NetBSD__)
#include <soundcard.h>
#elif defined(___SOMETHING_UNKNOWN__)
#include <sys/soundcard.h>
#elif defined(_UNIXWARE)
#include <sys/soundcard.h>
#else
#undef HARDWARE_VOLUME
#endif

void Mixer::init()
{
 if((fd = ::open ("/dev/mixer", O_RDWR)) < 0)
  {
   return;
  }
 else
  {
#define ERROR { fd=-1; return; }
   int devmask, recmask, i_recsrc, stereodevs;
   // Mixer is open. Now define properties
   if (ioctl(fd, SOUND_MIXER_READ_DEVMASK, &devmask) == -1) ERROR
   if (ioctl(fd, SOUND_MIXER_READ_RECMASK, &recmask) == -1) ERROR
   if (ioctl(fd, SOUND_MIXER_READ_RECSRC, &i_recsrc) == -1) ERROR
   if (ioctl(fd, SOUND_MIXER_READ_STEREODEVS, &stereodevs) == -1) ERROR
   if (!devmask) ERROR
#undef ERROR
  }
}

void Mixer::close()
{
 ::close(fd);
}

void Mixer::setVolume(int percent)
{
 percent=percent+(percent<<8);
 ioctl(fd, MIXER_WRITE(0), &percent);
}

int Mixer::volume()
{
 int volume, left, right;
 left=100;
 if(ioctl(fd, MIXER_READ(0), &volume) != -1)
  {
   left=volume & 0x7f;
   right=(volume>>8) & 0x7f;
   left=(left+right)/2;
  }
 return left;
}

void Mixer::mute()
{
 oldvol = volume();
 setVolume(0);
}

void Mixer::unmute()
{
 setVolume(oldvol);
}

int Mixer::fd = 0;
int Mixer::oldvol = 0;
