(* $Id: optional.ml,v 1.1 2004/08/05 13:40:59 rwmj Exp $ *)

open Printf

open ExamplesLib

let () =
  (* Supply the name of the database on the command line. *)
  let dbname = if Array.length Sys.argv > 1 then Sys.argv.(1) else "rich" in

  let dbh = set_up_database dbname in

  (* There are various ways to deal with optional fields (NULLs) in
   * the database.  This matching function below demonstrates one
   * possible way.
   *)
  let sth = dbh#prepare "select name, nickname
                           from employees
                          order by 1" in
  sth#execute [];

  sth#iter (function
	      | [`String name; `String nickname] ->
		  printf "%s usually goes by the nickname %s.\n"
		    name nickname
	      | [`String name; `Null] ->
		  printf "%s doesn't have a nickname.\n" name
	      | _ -> assert false)
