(* $Id: simple-select.ml,v 1.1 2004/08/05 13:40:59 rwmj Exp $ *)

open Printf

open ExamplesLib

let () =
  (* Supply the name of the database on the command line. *)
  let dbname = if Array.length Sys.argv > 1 then Sys.argv.(1) else "rich" in

  let dbh = set_up_database dbname in

  (* This is how you do a simple SELECT statement. *)
  let sth = dbh#prepare "select e.name, e.id, p.name
                           from employees e, positions p
                          where e.position = p.id
                          order by 1" in
  sth#execute [];

  (* You almost always use #map or #iter when selecting multiple rows
   * from a database:
   *)
  sth#iter (function
	      | [`String name; `Int employee_id; `String position] ->
		  printf "%s (employee ID: %d) position: %s\n"
		    name employee_id position
	      | _ ->
		  (* If the database returns unexpected types, then we'll
		   * fail on the following assertion:
		   *)
		  assert false)
