/*
 * Implementation of miscellaneous utility functions.
 *
 * Music Applet
 * Copyright (C) 2006 Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 *
 */

#include <config.h>

#include "ma-util.h"

#include <glib/gi18n.h>


static void	split_time (gint time, gint *hours, gint *minutes, gint *seconds);


/*********************************************************************
 *
 * Public interface
 *
 *********************************************************************/

/*
 * If not for potential i18n issues, these strings could be pieced
 * together more succinctly.
 */

gchar *
ma_util_format_elapsed (gint elapsed)
{
	gint hours, minutes, seconds;

	if (elapsed < 0)
		elapsed = 0;

	split_time (elapsed, &hours, &minutes, &seconds);

	if (hours == 0)
	{
		/* To translators: MINUTES:SECONDS */
		return g_strdup_printf (_("%d:%02d"), minutes, seconds);
	}
	else
	{
		/* To translators: HOURS:MINUTES:SECONDS */
		return g_strdup_printf (_("%d:%02d:%02d"), hours, minutes, seconds);
	}
}

gchar *
ma_util_format_elapsed_duration (gint elapsed, gint duration)
{
	gint elapsed_hours, elapsed_minutes, elapsed_seconds;
	gint duration_hours, duration_minutes, duration_seconds;

	g_return_val_if_fail (duration >= 0, NULL);

	if (elapsed < 0)
		elapsed = 0;

	split_time (elapsed, &elapsed_hours, &elapsed_minutes, &elapsed_seconds);
	split_time (duration, &duration_hours, &duration_minutes, &duration_seconds);

	if (duration_hours == 0)
	{
		/* To translators: ELAPSED of DURATION, using MINUTES:SECONDS */
		return g_strdup_printf (_("%d:%02d of %d:%02d"),
					elapsed_minutes, elapsed_seconds,
					duration_minutes, duration_seconds);
	}
	else
	{
		/* To translators: ELAPSED of DURATION, using HOURS:MINUTES:SECONDS */
		return g_strdup_printf (_("%d:%02d:%02d of %d:%02d:%02d"),
					elapsed_hours, elapsed_minutes, elapsed_seconds,
					duration_hours, duration_minutes, duration_seconds);
	}
}


/*********************************************************************
 *
 * Internal functions
 *
 *********************************************************************/

static void
split_time (gint time, gint *hours, gint *minutes, gint *seconds)
{
	*seconds = time % 60;
	time /= 60;
	*minutes = time % 60;
	*hours = time / 60;
}
