/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: murasaki.h,v 3.6 2002/01/21 17:50:33 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASAKI_H
#define	_MURASAKI_H

#include	<syslog.h>
#include	"datatype.h"

#define	LOG_LEVEL	LOG_CONS

#ifdef	DEBUG
#define	DPRINTF( args... )	syslog(args)
#define	DPRINT_LIST(list)	print_list(list)
#else
#define	DPRINTF( args... )
#define	DPRINT_LIST(list)
#endif

#define	MU_MURASAKI	"murasaki"
#define	MU_ARG_USB	"usb"
#define	MU_ARG_PCI	"pci"
#define	MU_ARG_NET	"net"
#define	MU_ARG_IEEE1394	"ieee1394"
#define	MU_USB	MU_MURASAKI "." MU_ARG_USB
#define	MU_PCI	MU_MURASAKI "." MU_ARG_PCI
#define	MU_NET	MU_MURASAKI "." MU_ARG_NET
#define	MU_IEEE1394	MU_MURASAKI "." MU_ARG_IEEE1394

#define	START_ARG		2
#define MODULE_MAX		8
/* module + loader + loader option + NULL */
#define	LIST_MAX		(MODULE_MAX + 2 + 1)	
#define	ALIAS_STR		"alias-"

/* usb */
extern int get_id_usb_product(MU_usb_config_t *);
extern int get_id_usb_type(MU_usb_config_t *);
/* pci */
extern int get_id_pci_class(MU_pci_config_t *);
extern int get_id_pci_id(MU_pci_config_t *);
extern int get_id_pci_slot(MU_pci_config_t *);
/* net */
extern int get_interface(MU_net_config_t *);
extern int execute(struct mu_op *,int );
/* ieee1394 */
extern int get_id_ieee1394(MU_ieee1394_config_t *);
/* common */
extern struct mu_op mu_op;
extern int get_depend(char **);
extern int get_script(char **,char **);
extern char *module_list[];
extern char *script_list[];
extern int match_config(char **,char *,char *,void *);
extern int load_module(struct mu_op *,int );	/* usb , pci */
extern int get_action(void);
extern void beep(int);
extern void print_config(void *);
extern void inform_config(void *);
extern int add_to_list(char **,char *,int);
extern void remove_from_list(char **,int);
extern int count_of_list(char **);
extern int debug;

#endif	/* _MURASAKI_H */
