; -*- coding: iso-2022-7bit  -*-
;;; u-cns-5.el --- tables between UCS and CNS 11643:1992 plain 5

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-5 'unicode-assoc
     'cns11643-5-vs-unicode-assoc)

(defvar cns11643-5-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(K!H(B . "0x6729") ; <CJK>
       (?$(K"\(B . "0x5E07") ; <CJK>
       (?$(K"f(B . "0x5FCB") ; <CJK>
       (?$(K#K(B . "0x5324") ; <CJK>
       (?$(K%7(B . "0x52B7") ; <CJK>
       (?$(K%8(B . "0x52B8") ; <CJK>
       (?$(K%:(B . "0x52B6") ; <CJK>
       (?$(K%;(B . "0x52BA") ; <CJK>
       (?$(K(r(B . "0x5C2E") ; <CJK>
       (?$(K)E(B . "0x6306") ; <CJK>
       (?$(K)i(B . "0x6B85") ; <CJK>
       (?$(K0F(B . "0x8C38") ; <CJK>
       (?$(K0U(B . "0x8ECE") ; <CJK>
       (?$(K2~(B . "0x688E") ; <CJK>
       (?$(K3T(B . "0x7309") ; <CJK>
       (?$(K5[(B . "0x8A2F") ; <CJK>
       (?$(K6j(B . "0x52DC") ; <CJK>
       (?$(K7=(B . "0x5921") ; <CJK>
       (?$(K7|(B . "0x5E3F") ; <CJK>
       (?$(K;$(B . "0x7B3F") ; <CJK>
       (?$(K;o(B . "0x83D0") ; <CJK>
       (?$(K;{(B . "0x86E7") ; <CJK>
       (?$(K?0(B . "0x6117") ; <CJK>
       (?$(KB](B . "0x8714") ; <CJK>
       (?$(KBl(B . "0x88D1") ; <CJK>
       (?$(KC-(B . "0x8CCB") ; <CJK>
       (?$(KCP(B . "0x8EED") ; <CJK>
       (?$(KDc(B . "0x52EC") ; <CJK>
       (?$(KDg(B . "0x52E8") ; <CJK>
       (?$(KGI(B . "0x7527") ; <CJK>
       (?$(KG~(B . "0x798C") ; <CJK>
       (?$(KH"(B . "0x7991") ; <CJK>
       (?$(KIN(B . "0x8660") ; <CJK>
       (?$(KK;(B . "0x9819") ; <CJK>
       (?$(KKL(B . "0x9904") ; <CJK>
       (?$(KKN(B . "0x999B") ; <CJK>
       (?$(KM*(B . "0x6184") ; <CJK>
       (?$(KN7(B . "0x729F") ; <CJK>
       (?$(KPU(B . "0x8770") ; <CJK>
       (?$(KQ:(B . "0x8CE3") ; <CJK>
       (?$(KQH(B . "0x8E37") ; <CJK>
       (?$(KR;(B . "0x9703") ; <CJK>
       (?$(KSb(B . "0x52F6") ; <CJK>
       (?$(KT^(B . "0x64CC") ; <CJK>
       (?$(KUi(B . "0x764A") ; <CJK>
       (?$(KVR(B . "0x7AB9") ; <CJK>
       (?$(KVi(B . "0x7BD7") ; <CJK>
       (?$(KYu(B . "0x98B4") ; <CJK>
       (?$(KZ&(B . "0x999F") ; <CJK>
       (?$(KZJ(B . "0x9B8D") ; <CJK>
       (?$(KZ[(B . "0x9E77") ; <CJK>
       (?$(K[r(B . "0x6BA9") ; <CJK>
       (?$(K\6(B . "0x764B") ; <CJK>
       (?$(K\C(B . "0x76A2") ; <CJK>
       (?$(KdH(B . "0x87F1") ; <CJK>
       (?$(Kfy(B . "0x9BBA") ; <CJK>
       (?$(KiC(B . "0x8804") ; <CJK>
       (?$(Kk3(B . "0x9BD8") ; <CJK>
       (?$(Kk?(B . "0x9D7C") ; <CJK>
       (?$(Kly(B . "0x7C46") ; <CJK>
       (?$(KqV(B . "0x957E") ; <CJK>
       (?$(KrK(B . "0x9C20") ; <CJK>
       (?$(KrN(B . "0x9C22") ; <CJK>
       (?$(KrQ(B . "0x9C1E") ; <CJK>
       (?$(KsG(B . "0x7C61") ; <CJK>
       (?$(Kt8(B . "0x8970") ; <CJK>
       (?$(Ku-(B . "0x9C43") ; <CJK>
       (?$(KuE(B . "0x9DE0") ; <CJK>
       (?$(Kv](B . "0x9459") ; <CJK>
       (?$(KzS(B . "0x9C72") ; <CJK>
       (?$(K{{(B . "0x7228") ; <CJK>
       ))))

(provide 'u-cns-5)

;;; u-cns-5.el ends here
 
