/*
// $Id: //open/mondrian/src/main/mondrian/olap/CellProperty.java#3 $
// This software is subject to the terms of the Eclipse Public License v1.0
// Agreement, available at the following URL:
// http://www.eclipse.org/legal/epl-v10.html.
// Copyright (C) 1998-2002 Kana Software, Inc.
// Copyright (C) 2001-2007 Julian Hyde and others
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
//
//
*/
package mondrian.olap;

/**
 * Represents Cell Property.
 *
 * @author Shishir
 * @version $Id: //open/mondrian/src/main/mondrian/olap/CellProperty.java#3 $
 * @since 08 May, 2007
 */

public class CellProperty extends QueryPart {
    private String name;

    public CellProperty(Object name) {
        this.name = name.toString();
    }

    /**
     * checks whether cell property is equals to passed parameter.
     * It adds '[' and ']' before and after the propertyName before comparing.
     * The comparison is case insensitive.
     */
    public boolean isNameEquals(String propertyName) {
        return name.equalsIgnoreCase(Util.quoteMdxIdentifier(propertyName));
    }

    public String toString() {
        return name;
    }
}

// End CellProperty.java