/*****************************************************************************/

/*
 *      p3dapp.h  --  AO-40 P3D Telemetry Decoder Application Header File.
 *
 *      Copyright (C) 2000
 *        Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*****************************************************************************/

#ifndef _P3DAPP_H
#define _P3DAPP_H

/* ---------------------------------------------------------------------- */

#define _GNU_SOURCE
#define _REENTRANT

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>

#include "modem.h"
#include "soundio.h"

/* ---------------------------------------------------------------------- */

extern struct modulator *modchain;
extern struct demodulator *demodchain;

extern GtkWidget *specwindow, *scopewindow, *receivewindow, *srcselwidget, *fileselwidget;
extern void error_dialog(const gchar *text);
extern void do_source_select(void);

extern int xml_setprop(const char *typname, const char *propname, const char *data);
extern int xml_getprop(const char *typname, const char *propname, char *buf, unsigned int bufsz);

/* diagnostics stuff */
extern void diag_stop(void);
extern int diag_start(unsigned int filein);

extern const struct modemparams stpparams[];

/* ---------------------------------------------------------------------- */
#endif /* _P3DAPP_H */
