/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _WIN_UTIL_H_
#define _WIN_UTIL_H_

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#include "wm.h"
#include "main_client.h"
#include "client_common.h"
#include "base_client.h"
#include "dialog_client.h"
#include "misc.h"

void wu_drag(client *c);
void draw_outline(Client *c);
void wu_get_mouse_position(wm *w, int *x, int *y);
void wu_drag(Client *c);
void wu_allow_xstroke( Wm *w, Window win);
int wu_trim_title( Wm *w, char *name, int max_width );
#endif
