/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _MISC_H_
#define _MISC_H_

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#include "structs.h"
#include "wm.h"
#include "main_client.h"


void err(const char *fmt, ...);
void dbg(const char *fmt, ...);
int max(int n, ...);
void fork_exec(char *cmd);
void sig_handler(int signal);
int handle_xerror(Display *dpy, XErrorEvent *e);
int ignore_xerror(Display *dpy, XErrorEvent *e);
void dump(client *c);
void dump_clients(wm* w);
#ifdef USE_XFT
int max_xstringChars(wm *w, int *width, char *txt, XftFont *font_info);
#else
int max_xstringChars(wm *w, int *width, char *txt, XFontStruct* font_info);
#endif

#endif _MISC_H_

