/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <syslog.h>
#include <string.h>
#include <stdlib.h>

#include "mserver.h"

extern FILE *outsock;
FILE *tfile;

/* This function will execute the kill script for a connection. If the
connection is unknown (or a kill method is undefined)  it will execute the
default kill method */
void mserver_kill(void)
{
	if (getstat())
	{
		char cname[1024];
		char kill_action[1024];
		char prekill[1024];
		
		cfile_getcname(cname);

		if (config_getvalue_bool("multiclientkill", true) == false)
		{
			if (child_count() > 1)	
			{
				fprintf(outsock, "ERROR: There are %d other users connected the server, wait for them to disconnect before killing the connection!\n", (child_count() - 1));
				return;
			}
		}
	
		if (!auth_check(cname, AUTH_DISCONNECT))
		{
			fprintf(outsock, "ERROR: You are not authorized to manipulate this connection!!\n");
			return;
		}

		if (shmem_get_kill_lock() > 0)
		{
			/*
			 * If we allow pending KILL requests, we will set
			 * the flag to true here and simply return SUCCESS if
			 * the server is locked.
			 */
			if (config_getvalue_bool("lock_pendingkill", false) == true)
			{
				shmem_set_pending_kill(true);
				fprintf(outsock, "SUCCESS\n");
				return;
			}
			else
			{
				fprintf(outsock, "ERROR: Server is currently locked!\n");
				return;
			}
		}

		config_getvalue_cname ("kill", kill_action, 1024);
		syslog (LOG_DEBUG, "kill action: %s", kill_action);

		if (!strncmp(kill_action, "internal", 1024))
		{	
			FILE *lock;

			char kill_sig[1024];
			char temp[1024];
			char lockfile[1024];

			int pid;

			config_getvalue("killsig", kill_sig, 1024);
			config_getvalue("lockfile", lockfile, 1024);

			lock = fopen(lockfile, "r");

			if (lock == NULL)
			{
				syslog(LOG_WARNING, "Internal kill method did not correctly kill connection, could not open lockfile");
				fprintf(outsock, "ERROR: Internal kill method did not correctly kill connection, please notify your sysadmin!\n");
				return;
			}

			fgets(temp, 1024, lock);
			fclose (lock);

			pid = atoi(temp);

			snprintf(kill_action, 1024, "kill %s %d", kill_sig, pid);
		}

		config_getvalue_cname ("prekill", prekill, 1024);
		if(strncmp(prekill, "", 1024))
		{
			util_system_wait (prekill);
		}

		util_system_wait (kill_action);

		util_sleep(config_getvalue_int("statwait", 0));

		if (!getstat())
		{
			char command[1024];
			config_getvalue("linkdown", command, 1024);
			util_system(command);

			fprintf(outsock, "SUCCESS\n");
		}
		else
		{
			syslog (LOG_WARNING, "Script (%s) did not correctly kill connection", kill_action);
			fprintf(outsock, "ERROR: Script did not correctly kill connection, please notify your sysadmin!\n");
		}
	}
	else
	{
		fprintf (outsock, "ERROR: There is no active connection!\n");	
	}
}

/* This function will execute the kill script for a connection. If the
connection is unknown (or a kill method is undefined)  it will execute the
default kill method */
void mserver_kill_silent(void)
{
	if (getstat())
	{
		char cname[1024];
		char kill_action[1024];
		char prekill[1024];
		
		if (shmem_get_kill_lock() > 0)
		{
			return;
		}

		cfile_getcname(cname);
		config_getvalue_cname ("kill", kill_action, 1024);

		if (!strncmp(kill_action, "internal", 1024))
		{	
			FILE *lock;

			char kill_sig[1024];
			char temp[1024];
			char lockfile[1024];

			int pid;

			config_getvalue("killsig", kill_sig, 1024);
			config_getvalue("lockfile", lockfile, 1024);

			lock = fopen(lockfile, "r");

			if (lock == NULL)
			{
				syslog(LOG_WARNING, "Internal kill method did not correctly kill connection, could not open lockfile");
				return;
			}

			fgets(temp, 1024, lock);
			fclose (lock);

			pid = atoi(temp);

			snprintf(kill_action, 1024, "kill %s %d", kill_sig, pid);

		}

		config_getvalue_cname ("prekill", prekill, 1024);
		if(strncmp(prekill, "", 1024))
		{
			util_system_wait (prekill);
		}

		util_system_wait (kill_action);

		util_sleep(config_getvalue_int("statwait", 0));

		if (getstat())
		{
			syslog (LOG_WARNING, "Script (%s) did not correctly kill connection", kill_action);
		}
		else
		{
			char command[1024];
			config_getvalue_cname("linkdown", command, 1024);
			util_system(command);
		}
	}
}
