/**
 * \file QMath.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

#include "QMath.h"
#include "QMathDialog.h"
#include "QMathMatrixDialog.h"
#include "QDelimiterDialog.h"

#include "gettext.h"

namespace lyx {
namespace frontend {

typedef QController<ControlMath, QView<QMathDialog> > math_base;


QMath::QMath(Dialog & parent)
	: math_base(parent, _("Math Panel"))
{}


void QMath::build_dialog()
{
	dialog_.reset(new QMathDialog(this));
}


typedef QController<ControlMath, QView<QMathMatrixDialog> > matrix_base;


QMathMatrix::QMathMatrix(Dialog & parent)
	: matrix_base(parent, _("Math Matrix"))
{}


void QMathMatrix::build_dialog()
{
	dialog_.reset(new QMathMatrixDialog(this));
}


typedef QController<ControlMath, QView<QDelimiterDialog> > delimiter_base;


QMathDelimiter::QMathDelimiter(Dialog & parent)
	: delimiter_base(parent, _("Math Delimiter"))
{}


void QMathDelimiter::build_dialog()
{
	dialog_.reset(new QDelimiterDialog(this));
}

} // namespace frontend
} // namespace lyx
