import unittest, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.debug import dprint
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks

linda.checks = Checks()

class StandardsVersionCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/standards_version.py', {'_': __builtins__['_'], \
            'dprint': dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][1]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.po_keys = POFileParser('po/en.po')
        
    def test_standards_version(self):
        "Check the sanity of StandardsVersionCheck"
        method = getattr(self.instance, 'standards_version')
        self.instance.information = {'dsc': {}}
        method()
        self.assert_('no-standards-version' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'no-standards-version'), True)
        self.instance.information['dsc']['standards-version'] = '1.0'
        method()
        self.assert_('incorrect-standards-version' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'incorrect-standards-version'), True)
        self.instance.information['dsc']['standards-version'] = '2.0.0'
        method()
        self.assert_('ancient-standards-version' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'ancient-standards-version'), True)
        self.instance.information['dsc']['standards-version'] = '3.0.0'
        method()
        self.assert_('out-date-standards-version' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'out-date-standards-version'), True)
        self.instance.information['dsc']['build-conflicts'] = 'foobar'
        method()
        self.assert_('build-deps-wrong-s-v' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'build-deps-wrong-s-v'), True)
        self.instance.information['dsc']['standards-version'] = '4.0.0'
        method()
        self.assert_('newer-standards-version' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'newer-standards-version'), True)

