/***************************************************************************
                          strat_map.h  -  description
                             -------------------
    begin                : Fri Jul 27 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __STRAT_MAP_H
#define __STRAT_MAP_H

/*
====================================================================
Is called after scenario was loaded in init_engine() and creates
the strategic map tile pictures, flags and the strat_map itself +
unit_layer
====================================================================
*/
void strat_map_init( Engine *engine );
/*
====================================================================
Clean up stuff that was allocated by strat_map_init()
====================================================================
*/
void strat_map_clear();

/*
====================================================================
Update the bitmap containing the strategic map.
====================================================================
*/
enum { RECREATE_UNIT_LAYER = 1L << 1, RECREATE_STRAT_MAP = 1L << 2, RECREATE_FLAG_LAYER = 1L << 3 };
void strat_map_update( Engine *engine, int flags );

/*
====================================================================
Handle SDL input. If mouse pointer is on a map tile x,y is returned
and true.
====================================================================
*/
int get_strat_map_pos( int mouse_x, int mouse_y, int *x, int *y );

#endif