/***************************************************************************
                          ai_action.c  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>

#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include "sdl.h"
#include "dynlist.h"
#include "config.h"
#include "tools.h"
#include "file.h"
#include "nation.h"
#include "unit.h"
#include "ai_action.h"

/* this is the current unit an action may be created for */
extern Unit *cur_unit;

/*
====================================================================
In case a double-action (e.g. MOVE_ATTACK) is returned the first
action is processed and the second action is stored and then
processed before ai_get_action() is called again.
====================================================================
*/
AI_Action stored_action;
int action_count = 0;
void ai_store_action( AI_Action action )
{
    stored_action = action;
    action_count = 1;
}
int ai_get_stored_action( AI_Action *action )
{
    if ( action_count == 0 ) return 0;
    *action = stored_action;
    action_count = 0;
    return 1;
}

/*
====================================================================
These functions 'create' an AI action from the passed arguments. For
functions that require a unit the cur_unit pointer defined in
ai.c is used.
====================================================================
*/
AI_Action ai_no_action()
{
    AI_Action action;
    action.unit = cur_unit;
    action.type = AI_NO_ACTION;
    return action;
}
AI_Action ai_end_turn_action()
{
    AI_Action action;
    action.unit = cur_unit;
    action.type = AI_END_TURN;
    return action;
}
AI_Action ai_move_action( int x, int y )
{
    AI_Action action;
    action.unit = cur_unit;
    action.type = AI_MOVE;
    action.x = x;
    action.y = y;
    return action;
}
AI_Action ai_attack_action( Unit *target )
{
    AI_Action action;
    action.unit = cur_unit;
    action.type = AI_ATTACK;
    action.target = target;
    return action;
}
AI_Action ai_move_attack_action( int x, int y, Unit *target )
{
    AI_Action action;
    action.unit = cur_unit;
    action.type = AI_MOVE_ATTACK;
    action.x = x;
    action.y = y;
    action.target = target;
    return action;
}
AI_Action ai_supply_action( )
{
    AI_Action action;
    action.unit = cur_unit;
    action.type = AI_SUPPLY;
    return action;
}
