#ifndef _KVI_BIFF_H_INCLUDED_
#define _KVI_BIFF_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Authors:
//       Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//       Szymon Stefanek <stefanek@tin.it>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qobject.h>
#include <qptrlist.h>

#define KVI_BIFF_VERSION "0.1.0"
#define BIFF_NULL_STRING "[!-NULL-!]"

class QTimer;

class KviBiffMailbox;
class KviBiffSysTray;
class KviBiffSocket;
class KviStr;
class KviWindow;

typedef struct
{
	bool         autoCheckAll;
	unsigned int autoCheckInterval;
	bool         systrayOnStartup;
	bool         beVerbose;
	unsigned int timeout;
} KviBiffConfig;

class KviBiff : public QObject
{
	Q_OBJECT
public:
	KviBiff();
	~KviBiff();
protected:
	QPtrList<KviBiffMailbox> *m_pMailboxList;     // The main list of mailboxes
	QString                   m_pCurrentIcon;
	QPtrList<KviBiffSysTray> *m_pBiffWidgetList;  // The list of the docked widgets
	KviBiffSocket            *m_pSocket;
	QTimer                   *m_pTimer;
	KviBiffMailbox           *m_pCurMailbox;
	KviWindow                *m_window;
	KviBiffConfig             m_config;
	bool                      m_checkingAll;
public:
	QPtrList<KviBiffMailbox> *const mailboxList() const;
	const KviBiffConfig &configStruct()           const;

	const KviBiffMailbox *const findMailbox(const char *user, const char *hostname) const;

	QString currentWidgetIcon();
	void registerSysTrayWidget(KviBiffSysTray *);
	void unregisterSysTrayWidget(KviBiffSysTray *);
	void start();
	void stop();

	/**
	 * Is the check timer running?
	 */
	bool isRunning();

	/**
	 * Show message on systray for some time.
	 */
	void systrayMsg(const char *t = 0, uint time = 70000, bool permt = false);

public slots:
	void slotConfig();
	void slotConfigureMailboxes();
	void slotCheckMailIn(int);     // Activated by signal from popup menu
	void slotCheckAll();
	void stopCheckingMail();

private:
	void readConfig();
	void saveConfig();

	const KviStr encryptString(const KviStr &) const;
	const KviStr decryptString(const KviStr &) const;

	bool checkMailbox(KviBiffMailbox *);

protected slots:
	void checkAllMailboxes();
	void socketResolving();
	void socketConnected();
	void socketLoggedIn();
	void socketError(const char *err);
	void socketJobDone();

	void slotApplyOptions();
	void slotKillConfigDialog();

signals:
	void connectedToServer();
};

#endif // _KVI_BIFF_H_INCLUDED_
