#ifndef _KVI_SYSTRAY_IOLED_H_INCLUDED_
#define _KVI_SYSTRAY_IOLED_H_INCLUDED_

// =============================================================================
//
//      --- kvi_systray_ioled.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_systray_widget.h"

class KviSysTray;

class KviSysTrayIoLed : public KviSysTrayWidget
{
	friend class KviIrcSocket;
	Q_OBJECT
public:
	KviSysTrayIoLed(KviSysTray *parent);
	~KviSysTrayIoLed();
protected:
	int m_timer;
	int m_iInLed;
	int m_iOutLed;
public:
	void clear();

	virtual void hide();
	virtual void show();
protected:
	void dataMessageReceived();
	void dataMessageSent();

	virtual QString icon();

	virtual void timerEvent(QTimerEvent *);
	virtual void paintEvent(QPaintEvent *);
};

#endif // _KVI_SYSTRAY_IOLED_H_INCLUDED_
