/***************************************************************************
                       ftp_vfs.cpp
                   -------------------
    copyright            : (C) 2000 by Rafi Yanai
    e-mail               : krusader@users.sourceforge.net
    web site             : http://krusader.sourceforge.net
 ---------------------------------------------------------------------------

 ***************************************************************************

  A 

     db   dD d8888b. db    db .d8888.  .d8b.  d8888b. d88888b d8888b.
     88 ,8P' 88  `8D 88    88 88'  YP d8' `8b 88  `8D 88'     88  `8D
     88,8P   88oobY' 88    88 `8bo.   88ooo88 88   88 88ooooo 88oobY'
     88`8b   88`8b   88    88   `Y8b. 88~~~88 88   88 88~~~~~ 88`8b
     88 `88. 88 `88. 88b  d88 db   8D 88   88 88  .8D 88.     88 `88.
     YP   YD 88   YD ~Y8888P' `8888Y' YP   YP Y8888D' Y88888P 88   YD

                                                     S o u r c e    F i l e

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT includes
#include <qdir.h>
// KDE includes
#include <kmimetype.h>
#include <kio/jobclasses.h>
#include <klocale.h>
#include <kio/job.h>
#include <kmessagebox.h>
// Krusader includes
#include "ftp_vfs.h"
#include "krpermhandler.h"
#include "../Dialogs/krdialogs.h"
#include "../Dialogs/krpleasewait.h"
#include "../krusader.h"
#include "../defaults.h"
#include "../resources.h"

ftp_vfs::ftp_vfs(QString origin,QWidget* panel):vfs(panel){
  supportCopyTo = true;
  supportMoveFrom = true;     // the big 4 is supported by ftp vfs...
 	supportDelete = true;
 	supportMoveTo = true;
	// set the writable attribute
	isWritable = true;
 	
  vfs_filesP = &vfs_files;
  vfs_files.setAutoDelete(true);
		
	// breakdown the url;
	QString remoteDir = origin.mid(origin.find("/",7));
	origin.truncate(origin.find("/",7));
	port = 0;	

	if ( origin.contains('@') ) { // url contains at least loginName		
		if( origin.find("@") < origin.findRev(":") ) { // url contains port
			port = origin.mid(origin.find(":",origin.find("@"))+1).toInt();
			origin.truncate(origin.find(":",origin.find("@")));
		}
		hostName = origin.mid(origin.findRev("@")+1);
		origin.truncate(origin.findRev("@"));
		if( origin.find(":",6) != -1 ) {// url contains password
			password = origin.mid(origin.findRev(":")+1);
			origin.truncate(origin.find(":",6));
		}
		loginName = origin.mid(origin.findRev("/")+1);
		origin.truncate(origin.findRev("/")+1);
	}
  else { // no @ but we did add a port number...
  	port = origin.mid(origin.find(":",6)+1).toInt();
		origin.truncate(origin.find(":",6));
	}
	vfs_type="ftp";
	
	KURL url = origin+hostName+remoteDir;
	if( !loginName.isEmpty()) url.setUser(loginName);
	if( !password.isEmpty() ) url.setPass(password);
	if( port ) url.setPort(port);

	if ( url.isMalformed() ) {
    QString tmp = i18n("Malformed URL\n%1").arg(url.url());
    if (!quietMode) KMessageBox::sorry(krApp, tmp);
		error = true;
    return;
  }

	
	// tell the user to wait
  krApp->startWaiting("Connecting to: "+url.prettyURL(),0,true);
	
	// Try to connect to host
	krConfig->setGroup("Look&Feel");
	dir.openURL(url,krConfig->readBoolEntry("Show Hidden",_ShowHidden));
	krApp->plzWait->setJob( dir.job() );
	connect(dir.job(),SIGNAL(result(KIO::Job*)),this,SLOT(slotAddFiles(KIO::Job*)));
}

void ftp_vfs::slotAddFiles(KIO::Job* job=0){
	if( job && job->error() ){
  	error = true;
  	krApp->stopWait();
		return;
	}

	// first we set the origin pass and @ user...
	vfs_origin = KURL::decode_string(dir.url().prettyURL(-1));
  password = dir.url().pass();
  loginName = dir.url().user();
	
	if(vfs_origin.right(1) == "/" ) vfs_origin = vfs_origin.left(vfs_origin.length()-1);
  // then we clear the the list
	vfs_files.clear();

	if (!quietMode) emit startUpdate();

	// get the first file
	KFileItem* kfi = dir.items().first();
	// as long as u can find files - add them to the vfs
  while( kfi!=0 ){
  	ftp_vfile *temp;
		// get file statistics
		QString name=kfi->text();
		if (name=="." || name == ".." ) continue; // we dont need the "." entery...
	
		unsigned long size = kfi->size();
  	QString perm = KRpermHandler::perm2QString(kfi);
		QString	dateTime = KRpermHandler::time2QString(kfi->time(256 | 4 | 2));
		bool symLink = kfi->isLink();
		uid_t owner= 0;
		gid_t group= 0;
		mode_t mode = kfi ->mode();
		QString mime; // set the mimetype
		if( kfi->isDir() ) mime = "inode/directory";
		else mime = KMimeType::findByURL( kfi->url(),mode,false,true)->name();
		QString symDest = "";
		if(symLink)symDest= kfi->linkDest();
		// create a new virtual file object
  	temp=new ftp_vfile(name,size,perm,dateTime,symLink,owner,group,mime,symDest,mode);
  	// set the ftp file permissions
  	temp->setWrite(KRpermHandler::ftpWriteable (kfi->user(),loginName,perm));
  	temp->setRead (KRpermHandler::ftpReadable  (kfi->user(),loginName,perm));
  	temp->setExec (KRpermHandler::ftpExecutable(kfi->user(),loginName,perm));
  	
  	vfs_addToList(temp);
		kfi=dir.items().next();
	}
	if (!quietMode) emit endUpdate();
	krApp->stopWait();
}

bool ftp_vfs::vfs_refresh(QString origin) {
	error = false;
	
	if( origin.find('/',7) == -1 ) origin=origin+"/";
	KURL url = origin.left(origin.find('/',7));
	url.setPath(origin.mid (origin.find('/',7)));
	if( !loginName.isEmpty()) url.setUser(loginName);
	if( !password.isEmpty() ) url.setPass(password);
	if ( port ) url.setPort(port);
	
	if ( url.isMalformed() ) {
    QString tmp = i18n("Malformed URL\n%1").arg(url.url());
    if (!quietMode) KMessageBox::sorry(krApp, tmp);
		error = true;
    return false;
  }
	
	// tell the user to wait
  //krApp->startWaiting("Connecting: "+origin, 0, true);
		
	// Open the directory	marked by origin
	krConfig->setGroup("Look&Feel");
	dir.openURL(url,krConfig->readBoolEntry("Show Hidden",_ShowHidden));
  //krApp->plzWait->setJob( dir.job() );
//	connect(dir.job(),SIGNAL(result(KIO::Job*)),this,SLOT(slotAddFiles(KIO::Job*)));
	connect(&dir,SIGNAL( canceled()),this,SLOT(slotAddFiles()));
  connect(&dir,SIGNAL(completed()),this,SLOT(slotAddFiles()));
	return true;
}


// copy a file to the vfs (physical)	
void ftp_vfs::vfs_addFiles(KURL::List *fileUrls,KIO::CopyJob::CopyMode mode,QWidget* toNotify,QString dir){
  KURL destUrl = this->dir.url();
  if(dir != "") destUrl.addPath(dir);


	destUrl.setUser(loginName);
  destUrl.setPass(password);
  if ( port ) destUrl.setPort(port);
	
  KIO::Job* job = new KIO::CopyJob(*fileUrls,destUrl,mode,false,true );
  connect(job,SIGNAL(result(KIO::Job*)),this,SLOT(vfs_refresh()) );
  if(mode == KIO::CopyJob::Move) // notify the other panel
    connect(job,SIGNAL(result(KIO::Job*)),toNotify,SLOT(refresh()) );
}

// remove a file from the vfs (physical)
void ftp_vfs::vfs_delFiles(QStringList *fileNames){
	KURL::List filesUrls;
	KURL url;

 	// names -> urls
	for(uint i=0 ; i<fileNames->count(); ++i){
		QString filename = (*fileNames)[i];
		url = dir.url();
    url.addPath(filename);
		url.setUser(loginName);
    url.setPass(password);
		if ( port ) url.setPort(port);
    filesUrls.append( url );
	}
	KIO::Job *job = new KIO::DeleteJob(filesUrls, false, true);
	connect(job,SIGNAL(result(KIO::Job*)),this,SLOT(vfs_refresh()));
}


KURL::List* ftp_vfs::vfs_getFiles(QStringList* names){
  KURL url;
  KURL::List* urls = new KURL::List();
  for(QStringList::Iterator name = names->begin(); name != names->end(); ++name){
    url = vfs_getFile(*name);
    url.setUser(loginName);
    url.setPass(password);
		if ( port ) url.setPort(port);
    urls->append(url);
  }
  return urls;
}


// return a path to the file
QString ftp_vfs::vfs_getFile(QString name){	
	KURL url = dir.url();
	
	if (vfs_search(name)->vfile_isDir())
		url.addPath(name+"/");
	else
	  url.addPath(name);

	url.setUser(loginName);
  url.setPass(password);
  if ( port ) url.setPort(port);

  return url.url();
}

void ftp_vfs::vfs_mkdir(QString name){
  KURL url =  dir.url();
	url.addPath(name);
  url.setUser(loginName);
  url.setPass(password);
  if ( port ) url.setPort(port);

	KIO::SimpleJob* job = KIO::mkdir(url);
	connect(job,SIGNAL(result(KIO::Job*)),this,SLOT(vfs_refresh()));
}


void ftp_vfs::vfs_rename(QString fileName,QString newName){
  KURL::List fileUrls;
  KURL url = dir.url();
  url.addPath(fileName) ;
  url.setUser(loginName);
  url.setPass(password);

  fileUrls.append(url);

	KURL dest = dir.url();
	dest.setPath(newName);
	dest.setUser(loginName);
  dest.setPass(password);
	if ( port ) dest.setPort(port);

  KIO::Job *job = new KIO::CopyJob(fileUrls,dest,KIO::CopyJob::Move,false,true );
	connect(job,SIGNAL(result(KIO::Job*)),this,SLOT(vfs_refresh()));
}

QString ftp_vfs::vfs_workingDir(){
	QString ret = vfs_origin;
	if ( !password.isEmpty() ) ret.replace(QRegExp("@"),":"+password+"@");
  return ret;
}
	
#include "ftp_vfs.moc"
