//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsetclustertablewidget1.h"

// include files for KDE
#include <kcombobox.h>

// application specific includes
#include "../DbObjects/kpgtableindexesfolder.h"
#include "../kpgutil.h"

KPGSetClusterTableWidget1::KPGSetClusterTableWidget1(QWidget *parent, const char *name, const QString & strNamespace, KPGTable *pTable)
 : KPGSetClusterTableWidget1Base(parent, name)
{
	pTable->getTableIndexesFolder()->fillComboBoxWithChildItems(m_pComboBoxIndex);
	
	m_strNamespace = strNamespace;
	m_strTableName = pTable->text(0);
}

KPGSetClusterTableWidget1::~KPGSetClusterTableWidget1()
{
}

const QString KPGSetClusterTableWidget1::getSQL() const
{
	QString strSql("ALTER TABLE ");
	
	strSql.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName));
	
	strSql.append(" CLUSTER ON ");
	strSql.append(KPGUtil::quotedName(m_pComboBoxIndex->currentText()));
	strSql.append(";");
		
	return strSql;
}

#include "kpgsetclustertablewidget1.moc"
