//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifysequencewizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgsequence.h"
#include "kpgmodifysequencewidget1.h"


KPGModifySequenceWizard::KPGModifySequenceWizard(QWidget *parent, const char *name, const QString &strNamespace, KPGSequence *pSequence)
 : KPG3StepsWizard(parent, name)
{
  KPGModifySequenceWidget1 *pModifySequenceWidget1 = new KPGModifySequenceWidget1(WizardPage1, "KPGModifySequenceWidget1", strNamespace, pSequence);
  m_pPageWidget1 = pModifySequenceWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pModifySequenceWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  languageChange();
}

KPGModifySequenceWizard::~KPGModifySequenceWizard()
{
}

void KPGModifySequenceWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Modify sequence" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Sequence properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGModifySequenceWizard::showPage(QWidget *pPage)
{ 
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL;
		strSQL.append((static_cast <KPGModifySequenceWidget1 *> (m_pPageWidget1))->getSQL());
			
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
}

#include "kpgmodifysequencewizard.moc"
