//
// C++ Implementation: kpgcreatetablewizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablewizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qspinbox.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
//#include "../DbObjects/kpgconnection.h"
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgtablespacesfolder.h"
#include "kpgcreatetablewidget1.h"
#include "kpgcreatetablewidget2.h"
#include "kpgcreatetablewidget3.h"
#include "kpgcreatetablewidget4.h"
#include "kpgcreatetablewidget5.h"


KPGCreateTableWizard::KPGCreateTableWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
 : KPG7StepsWizard(parent, name)
{
    KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
    
	KPGCreateTableWidget1 *pCreateTableWidget1 = new KPGCreateTableWidget1(WizardPage1, "KPGCreateTableWidget1", listOfSchemas);
	m_pPageWidget1 = pCreateTableWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateTableWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
    	
	KPGCreateTableWidget2 *pCreateTableWidget2 = new KPGCreateTableWidget2(WizardPage2, "KPGCreateTableWidget2", pDatabase);
	m_pPageWidget2 = pCreateTableWidget2;
	WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
	connect(pCreateTableWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
	
	KPGCreateTableWidget3 *pCreateTableWidget3 = new KPGCreateTableWidget3(WizardPage3, "KPGCreateTableWidget3", pDatabase, true);
	m_pPageWidget3 = pCreateTableWidget3;
	WizardPage3Layout->addWidget(m_pPageWidget3, 0, 0);
	// always enabled, don't connect
	
	KPGCreateTableWidget4 *pCreateTableWidget4 = new KPGCreateTableWidget4(WizardPage4, "KPGCreateTableWidget4", pDatabase);
	m_pPageWidget4 = pCreateTableWidget4;
	WizardPage4Layout->addWidget(m_pPageWidget4, 0, 0);
	// always enabled, don't connect
	
	KPGCreateTableWidget5 *pCreateTableWidget5 = new KPGCreateTableWidget5(WizardPage5, "KPGCreateTableWidget5", true);
	m_pPageWidget5 = pCreateTableWidget5;
	WizardPage5Layout->addWidget(m_pPageWidget5, 0, 0);
	//connect(pCreateTableWidget5, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton5(bool)));
	
    // default schema in page 2 is the same as in page 1
    pCreateTableWidget2->m_pComboBoxSchema->setCurrentText(pCreateTableWidget1->m_pComboBoxSchema->currentText());
    pCreateTableWidget2->refreshListOfDatatypes();
    
    if(pServer->versionMajor() >= 8)
    {
        pServer->getTablespacesFolder()->fillComboBoxWithChildItems(pCreateTableWidget1->m_pComboBoxTablespace);
        pServer->getTablespacesFolder()->fillComboBoxWithChildItems(pCreateTableWidget3->m_pComboBoxTablespace);
        pServer->getTablespacesFolder()->fillComboBoxWithChildItems(pCreateTableWidget4->m_pComboBoxTablespace);
    }
    else
    {
        pCreateTableWidget1->m_pComboBoxTablespace->setEnabled(false);
        pCreateTableWidget3->m_pComboBoxTablespace->setEnabled(false);
        pCreateTableWidget4->m_pComboBoxTablespace->setEnabled(false);
    }
    
    if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 2)) || (pServer->versionMajor() > 8))
    {
        m_bVersion8_2OrNewer = true;
    }
    else
    {
        pCreateTableWidget1->m_pCheckBoxDefaultFillFactor->setEnabled(false);
        m_bVersion8_2OrNewer = false;
    }
      
    pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateTableWidget5->m_pListBoxUsersGroups);
    pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateTableWidget5->m_pListBoxUsersGroups);
  
	languageChange();
}


KPGCreateTableWizard::~KPGCreateTableWizard()
{
}

void KPGCreateTableWizard::languageChange()
{
    KPG7StepsWizard::languageChange();
		
	setCaption( i18n( "Create new Table" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - Table name" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Define columns" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Define table constraints" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Define table indexes" ) );
    setTitle( WizardPage5, i18n( "Step 5 - Define user rights" ) );
    setTitle( WizardPage6, i18n( "Step 6 - Review SQL statement" ) );
    setTitle( WizardPage7, i18n( "Step 7 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateTableWizard::showPage(QWidget *pPage)
{
	/*if(pPage == WizardPage2) // Step 2 - Define table columns
  {
    //--- Initialize create constraints page
    KPGCreateTableWidget1 *pCreateTableWidget1 = static_cast <KPGCreateTableWidget1 *> (m_pPageWidget1);
    KPGCreateTableWidget2 *pCreateTableWidget2 = static_cast <KPGCreateTableWidget2 *> (m_pPageWidget2);
    
    pCreateTableWidget2->fillDatatypes();
  }*/
  
    
  if(pPage == WizardPage3) // Step 3 - Define table constraints
	{
		//--- Initialize create constraints page
		KPGCreateTableWidget1 *pCreateTableWidget1 = static_cast <KPGCreateTableWidget1 *> (m_pPageWidget1);
		KPGCreateTableWidget2 *pCreateTableWidget2 = static_cast <KPGCreateTableWidget2 *> (m_pPageWidget2);
		KPGCreateTableWidget3 *pCreateTableWidget3 = static_cast <KPGCreateTableWidget3 *> (m_pPageWidget3);
				
		if(pCreateTableWidget2->isDirty1())
		{
			pCreateTableWidget3->setListOfAvailableColumns(pCreateTableWidget2->getListOfColumns());
			pCreateTableWidget2->clearDirty1();
		}
			
        // set table name and selected namespace
        pCreateTableWidget3->setNamespace(pCreateTableWidget1->m_pComboBoxSchema->currentText());
        pCreateTableWidget3->setTableName(pCreateTableWidget1->m_pLineEditTableName->text());
		    
		if(pCreateTableWidget3->m_pComboBoxRefTable->count() > 0)
			pCreateTableWidget3->refTableSelectChanged();
			
		pCreateTableWidget3->m_pLineEditConstraintName->setText(""); // clear preselected default name
	}
	
	if(pPage == WizardPage4) // Step 4 - Define table indexes
	{
		//--- Initialize create constraints page
		KPGCreateTableWidget1 *pCreateTableWidget1 = static_cast <KPGCreateTableWidget1 *> (m_pPageWidget1);
		KPGCreateTableWidget2 *pCreateTableWidget2 = static_cast <KPGCreateTableWidget2 *> (m_pPageWidget2);
		KPGCreateTableWidget4 *pCreateTableWidget4 = static_cast <KPGCreateTableWidget4 *> (m_pPageWidget4);
				
		if(pCreateTableWidget2->isDirty2())
		{
			pCreateTableWidget4->setListOfAvailableColumns(pCreateTableWidget2->getListOfColumns());
			pCreateTableWidget2->clearDirty2(); 
		}
		
		// Set connection, table name and namespace
		pCreateTableWidget4->setTableName(pCreateTableWidget1->m_pLineEditTableName->text());
		pCreateTableWidget4->setNamespace(pCreateTableWidget1->m_pComboBoxSchema->currentText());
	}
	
	if(pPage == WizardPage5) // Step 5 - Define user rights
	{
		KPGCreateTableWidget1 *pCreateTableWidget1 = static_cast <KPGCreateTableWidget1 *> (m_pPageWidget1);
		KPGCreateTableWidget5 *pCreateTableWidget5 = static_cast <KPGCreateTableWidget5 *> (m_pPageWidget5);
				
		// Set table name and namespace
		pCreateTableWidget5->setTableName(pCreateTableWidget1->m_pLineEditTableName->text());
		pCreateTableWidget5->setNamespace(pCreateTableWidget1->m_pComboBoxSchema->currentText());
	}
	
	if(pPage == WizardPage6) // Step 6 - Review SQL statement
	{
		KPGCreateTableWidget1 *pCreateTableWidget1 = static_cast <KPGCreateTableWidget1 *> (m_pPageWidget1);
		
		// prepare SQL statement
		QString strSQL;
		
		strSQL.append((static_cast <KPGCreateTableWidget1 *> (m_pPageWidget1))->getSQL());
		strSQL.append("\n(\n");
		
		strSQL.append((static_cast <KPGCreateTableWidget2 *> (m_pPageWidget2))->getSQL());
		strSQL.append((static_cast <KPGCreateTableWidget3 *> (m_pPageWidget3))->getSQL());
				
		strSQL.append("\n)");
		
		if(!m_bVersion8_2OrNewer)
		{
            if(pCreateTableWidget1->m_pCheckBoxWithoutOIDs->isChecked())
                strSQL.append(" WITHOUT OIDS");
            else
                strSQL.append(" WITH OIDS");
        }
        else
        {
            QString strOptions("\nWITH (");
            
            
            if(pCreateTableWidget1->m_pCheckBoxWithoutOIDs->isChecked())
                strOptions.append("OIDS=FALSE");
            else
                strOptions.append("OIDS=TRUE");
                
            if(pCreateTableWidget1->m_pCheckBoxDefaultFillFactor->isChecked() == false)
    	    strOptions.append(QString(", FILLFACTOR = %1").arg(pCreateTableWidget1->m_pSpinBoxFillFactor->value()));
    	    
    	    strOptions.append(")");
    	    
    	    strSQL.append(strOptions);
        }
			
		if(pCreateTableWidget1->m_pComboBoxTablespace->currentItem() > 0)
    	strSQL.append("\nTABLESPACE " + pCreateTableWidget1->m_pComboBoxTablespace->currentText());
    	    				
		strSQL.append(";");
		
		strSQL.append((static_cast <KPGCreateTableWidget4 *> (m_pPageWidget4))->getSQL());
		strSQL.append("\n\n");
		strSQL.append((static_cast <KPGCreateTableWidget5 *> (m_pPageWidget5))->getSQL());
				
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage7) // Step 7 - Check operation result
	{
		runQuery();
	}

	// call parent
	KPG7StepsWizard::showPage(pPage);
}


#include "kpgcreatetablewizard.moc"
