//
// C++ Implementation: kpgconversionsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgconversionsfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgconversionsfolder.h"

KPGConversionsFolderPropPage::KPGConversionsFolderPropPage(QWidget *pParent, KPGConversionsFolder *pConversionsFolder)
 : KPGPropertyPage(pParent, "KPGConversionsFolderPropPage")
{
	m_pConversionsFolder = pConversionsFolder;
	displayProperties();
}

KPGConversionsFolderPropPage::~KPGConversionsFolderPropPage()
{
}

void KPGConversionsFolderPropPage::displayProperties()
{
	setLabelText(i18n("Conversions &list:"));
	
	// field names
	QHeader* pHeader = m_pTableItems->horizontalHeader();
	
	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Is default"));
	pHeader->setLabel(nCol++, i18n("Source encoding"));
	pHeader->setLabel(nCol++, i18n("Destination encoding"));
 	pHeader->setLabel(nCol++, i18n("Conversion procedure"));
	pHeader->setLabel(nCol++, i18n("Owner"));

	KPGUtil::fillPropertiesTable(m_pConversionsFolder->resultConversions(), m_pTableItems);
}

