//
// C++ Interface: kpgtableconstraint
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTABLECONSTRAINT_H
#define KPGTABLECONSTRAINT_H

#include "kpgobject.h"

class KPGTableConstraintsFolder;

/**
  * Base class for all table constraints - primary key, foreign key, 
  * unique and check
  *
  * @author Lumir Vanek
  */
class KPGTableConstraint : public KPGObject
{
public:
    KPGTableConstraint(KPGTableConstraintsFolder *, const QString, pqxx::oid);
	KPGTableConstraint(KPGTableConstraintsFolder *, KPGTableConstraint *, const QString, pqxx::oid);
    ~KPGTableConstraint();

	// Get SQL object type 
  	virtual const char * getObjectType() const { return "CONSTRAINT"; }

	void setProperties(const pqxx::result::tuple &);
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
				
	/*
	 * Functions for accessing properties
	 */
	bool isDeferrable() const { return m_bIsDeferrable; }
	bool isDeferred() const { return m_bIsDeferred; }
	const QString & nspName() const { return m_strNspName;	}
	 
protected:

	/*
	 * Properties
	 */
	bool m_bIsDeferrable;
	bool m_bIsDeferred;
	QString m_strNspName;		
};

#endif
