/***************************************************************************
                          kpgtable.h  -  description
                             -------------------
    begin                : � led 6 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGTABLE_H
#define KPGTABLE_H

#include "kpgobject.h"

#include "kpgconnection.h"

class KPGTablesFolder;
class KPGTableColumnsFolder;
class KPGTableConstraintsFolder;
class KPGTableIndexesFolder;
class KPGRulesFolder;
class KPGTriggersFolder;

/**
  * Item, that represent database table
  *
  * @author Lumir Vanek
  */
class KPGTable : public KPGObject
{
public: 
	KPGTable(KPGTablesFolder *, const QString, pqxx::oid);
	KPGTable(KPGTablesFolder *, KPGTable *, const QString, pqxx::oid);
	~KPGTable();

  	virtual eNodeType type() const { return nodeTable; }
  	
  	// Get SQL object type 
  	virtual const char * getObjectType() const { return "TABLE"; }
  	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
  	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	// Refresh childs
	void refreshChildItems() throw(const KPGSqlException &);
	
	void setProperties(const pqxx::result::tuple &, bool, bool);
	
	/*
	 * Functions for accessing nested folders
	 */
		  
	KPGTableColumnsFolder * getTableColumnsFolder() { return m_pFolderColumns; }
	KPGTableConstraintsFolder * getTableConstraintsFolder() { return m_pFolderConstraints; }
	KPGTableIndexesFolder * getTableIndexesFolder() { return m_pFolderIndexes; }
	KPGRulesFolder * getRulesFolder() { return m_pFolderRules; }
	KPGTriggersFolder * getTriggersFolder() { return m_pFolderTriggers; }
	
	/*
	 * Functions for accessing nested results
	 */
		
  	const pqxx::result & resultColumns() const;
  	const pqxx::result & resultConstraints() const;
    const pqxx::result & resultIndexes() const;
    const pqxx::result & resultRules() const;
    const pqxx::result & resultTriggers() const;
    
    const pqxx::result queryStatistics() const;
    const pqxx::result queryIoStatistics() const;
    
	/*
	 * Functions for accessing properties
	 */
		
	pqxx::oid oidReltype() const { return m_oidReltype; }
	const QString & primaryKeyName() const { return m_strPrimaryKeyName; }
	const QString & owner() const { return m_strOwner; }
	const QString & tablespace() const { return m_strTablespace; }
	bool isToastTable() const { return m_strKind == "Toast table"; }
	const QString & acl() const { return m_strACL; }
	const QString & kind() const { return m_strKind; }
	long long size() const { return m_llSize; }
    const QString & prettySize() const { return m_strPrettySize; }
    long long sizeTotal() const { return m_llSizeTotal; }
    const QString & prettySizeTotal() const { return m_strPrettySizeTotal; }
    bool hasOids() const { return m_bHasOids; }
    bool hasSubclass() const { return m_bHasSubclass; }
	double estimatedRows() const { return m_dEstimatedRows; }
	const QString & primaryKeyColNumbers() const { return m_strPrimaryKeyColNumbers; }
	pqxx::oid oidTablespace() const { return m_oidTablespace; }
	pqxx::oid oidToastTable() const { return m_oidToastTable; } 
	const QString & toastTable() const { return m_strToastTable; }
  	  
protected:
	  
	virtual void activate();
	
protected:
	
	/*
	 * Properties
	 */
	pqxx::oid m_oidReltype;
	QString m_strOwner;
	QString m_strACL;
	bool m_bHasOids;
	bool m_bHasSubclass;
	double m_dEstimatedRows;
	QString m_strPrimaryKeyName;
	QString m_strPrimaryKeyColNumbers;
	pqxx::oid m_oidTablespace;   // For PostgreSQL 8 or newer 
	QString m_strTablespace;     // For PostgreSQL 8 or newer
	pqxx::oid m_oidToastTable; 
	QString m_strToastTable;  
	long long m_llSize;
  	QString m_strPrettySize;
	long long m_llSizeTotal;
  	QString m_strPrettySizeTotal;
  	QString m_strKind;
	
	// Folders with owned objects
  	KPGTableColumnsFolder *m_pFolderColumns;
	KPGTableConstraintsFolder *m_pFolderConstraints;
	KPGTableIndexesFolder *m_pFolderIndexes;
	KPGRulesFolder *m_pFolderRules;
	KPGTriggersFolder *m_pFolderTriggers;
	
	bool m_bIsLoaded;
};

#endif
