//
// C++ Interface: kpgoperatorclass
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGOPERATORCLASS_H
#define KPGOPERATORCLASS_H

#include <kpgobject.h>

class KPGOperatorClassesFolder;

/**
  * Operator Class defines index access method operator classes. 
  * Each operator class defines semantics for index columns of a particular 
  * data type and a particular index access method. Note that there can 
  * be multiple operator classes for a given data type/access method combination, 
  * thus supporting multiple behaviors. 
  *
  * @author Lumir Vanek
  */
class KPGOperatorClass : public KPGObject
{
public:
    KPGOperatorClass(KPGOperatorClassesFolder *, const QString, pqxx::oid);
	KPGOperatorClass(KPGOperatorClassesFolder *, KPGOperatorClass *, const QString, pqxx::oid);
    ~KPGOperatorClass();

	virtual eNodeType type() const { return nodeOperatorClass; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "OPERATOR CLASS"; }
	
	void setProperties(const pqxx::result::tuple &);
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return; }
		
	/*
	 * Functions for accessing properties
	 */
	bool isDefault() const { return m_bIsDefault; }
	pqxx::oid oidDataType() const { return m_oidDataType; }
	const QString & dataType() const { return m_strDataType; }
	pqxx::oid oidKeyType() const { return m_oidKeyType; }
	const QString & keyType() const { return m_strKeyType; }
	const QString & accessMethodName() const { return m_strAccessMethodName; }
	const QString & owner() const { return m_strOwner; }
	 
protected:

	/*
	 * Properties
	 */
	bool m_bIsDefault;
	pqxx::oid m_oidDataType;
	QString m_strDataType;
	pqxx::oid m_oidKeyType;
	QString m_strKeyType;
	QString m_strAccessMethodName;
	QString m_strOwner;
};

#endif
