/***************************************************************************
                             kinkattaplugin.h
                             -------------------
    begin                : Saturday Dec 1 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTAPLUGIN_H
#define KINKATTAPLUGIN_H

#include <qobject.h>
#include <qwidget.h>
#include <qstring.h>
class BuddyListWindow;
class TAim;
class ChatWindow;

/**
 * This is your information struct.
 * Every plugin needs to fill this struct up with all of the relevant information in the constructor.
 * @author Benjamin Meyer
 */
struct plugin_info{
  /**
   * The name of your plugin. Ex: "Babelfish Translator"
   */
  QString Name;
  
  /**
   * The author of your plugin. Ex: "Benjamin Meyer"
   */
  QString Author;
  
  /**
   * The plugin version. Ex: "1.0"
   */
  QString Version;
  
  /**
   * The homepage of this plugin. Ex: "None" or "Http://kinkatta.sourceforge.net"
   */
  QString HomePage;

  /**
   * If this plugin should be getting message in via the signals and slots
   * set this to true. i.e. This should be set for anything that watches
   * the incoming and outgoing messages.  The reason that this can be set
   * is to reduce the number of times a message in passed around.
   */
  bool messagePlugin;

  /**
   * If this plugin should be loaded on the application start you specify it here.
   */
  bool loadOnApplicationStart;
};

/**
 * KinkattaPlugin is the base class that all plugins are based upon.
 * @author Benjamin Meyer
 */

class KinkattaPlugin : public QObject {

Q_OBJECT
	
signals:
  /// Sends out a message.
  void goingOutChatMessage( QString message, QString buddy, bool isAuto, bool endIdleNess );

  /// Sends in a message.
  void goingInChatMessage( QString message, QString buddy, bool isAuto );
  
  /// Sends in a chat room message.
  void goingInChatRoomMessage( int room, QString message );

  /// Sends out a chat room message.
  void goingOutChatRoomMessage( int room, QString message );

public:
  /// Constructor.
  KinkattaPlugin( QWidget *parent=0, const char *name=0 );
  
  /// Deconstructor.
  virtual ~KinkattaPlugin();
  
  /// Sets the mainWindow and connection pointers up for access.
  virtual void setPointers( BuddyListWindow *mainWindow, TAim *connection ); 
  
  /// After this plugin has been initialized this function is called.
  virtual void initPlugin() = 0;
  
  /// The physical location of this plugin library on the hard drive.
  QString physicalLocation;
  QString kinkattaVersionNumber;

public slots:
  /// Requests the the configure widget for this plugin.
  virtual QWidget* configure( QWidget *parent );

  /// Get the settings from the configure widget and apply them.
  virtual void applyConfigure();	

  /// A message has come from the network for this plugin to handle.
  virtual void inChatMessage( QString message, QString buddy, bool isAuto );

  /// A message in going out for this plugin to handle.
  virtual void outChatMessage( QString message, QString buddy, bool isAuto, bool endIdleNess  );

  /// A chat room message has come from the network for this plugin to handle.
  virtual void inChatRoomMessage( int room, QString message );

  /// A chat room message in going out for this plugin to handle.
  virtual void outChatRoomMessage( int room, QString message );

  /// Return the struct of information about this plugin.
  virtual plugin_info getInformation();

  /// Return the name of this plugin.
  virtual QString getName();

  /// Return the author of this plugin.
  virtual QString getAuthor();

  /// Return the version of this plugin.
  virtual QString getVersion();

  /// When it is time to save settings this function is called.
  virtual void saveSettings();

protected:
  /// Pointer to the main window.
  BuddyListWindow *mainWindow;
  
  /// Pointer to the network connection.
  TAim *connection; 
  
  /// The plugin's information struct.
  plugin_info info;



  /// Are we currently connected to the network?
  bool onLine();
  
  /// Set the mainWindow to be away now with the message.
  void setAwayNow( QString message );

  ///  Get current information status
  QString getCurrentInfo();

  ///
  void setCurrentInfo( QString info );

};

#endif

// KinkattaPlugin.h

