/***************************************************************************
                           babelfishplugin.cpp 
                           -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "babelfishplugin.h"
#include "configure.h"
#include "chat.h"
#include <qspinbox.h>
#include <qstring.h>
#include "babel.h" 

extern "C"
{
  void* create_plugin()
  {
    return new BabelPlugin;
  }
};

/**
 * Constructor.  Initializes the plugin info and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
BabelPlugin::BabelPlugin(QWidget *parent, const char *name) : KinkattaComboPlugin( parent,name ){
  info.Name = "BabelFish Translation";
  info.Author = "Benjamin Meyer";
  info.Version = "1.00";
  info.HomePage = "http://kinkatta.sourceforge.net/";

  configureWidget = NULL;

  socket = new Babel(0, "socket");
  connect( socket, SIGNAL(translatedIn(QString, QString)), this, SLOT( messageTranslatedIn(QString, QString)));
  connect( socket, SIGNAL(translatedOut(QString, QString)), this, SLOT( messageTranslatedOut(QString, QString)));

}

/**
 * Does nothing.
 */
BabelPlugin::~BabelPlugin(){
}

/**
 * Sets up KinkattaComboPlugin settings.
 */
void BabelPlugin::initPlugin(){
  KinkattaComboPlugin::initPlugin();
}
 
/**
 * Does nothing.  There are no settings for this plugin.
 */
void BabelPlugin::applyConfigure(){
  if( configureWidget != NULL ) {
  }
}

/**
 * A relay that simply send out the translated message.
 * @param message the message that is set to go.
 * @param buddy the buddy the message is going to.
 */
void BabelPlugin::messageTranslatedOut( QString message, QString buddy ){
  emit ( goingOutChatMessage( message, buddy, false, true ) );
}

/**
 * A relay that simply send in the translated message.
 * @param message the message that is set to go.
 * @param buddy the buddy the message is going to.
 */
void BabelPlugin::messageTranslatedIn( QString message, QString buddy ){
  emit ( goingInChatMessage( message, buddy, false ) );
}

/**
 * Creates the configure widget if there isn't one.
 * @param parent the parent widget for the configure widget if one needs to be made.
 * @return QWidget the configure widget for this plugin.
 */
QWidget *BabelPlugin::configure( QWidget *parent ){
  if ( configureWidget == NULL )
    configureWidget = new Configure(parent, "Babel Translation Configure window.");
  return configureWidget;
}	

/**
 * If the message from buddy needs to be translated set up the socket and start
 * the translation.
 * @param message the text to translate.
 * @param buddy who is going to get the message.
 * @param isAuto wheather this message has been automaticly sent out.
 */
void BabelPlugin::inChatMessage( QString message, QString buddy, bool isAuto  ){
  Chat *window = windows.first();
  KinkattaComboBox *b = NULL;
  while(window != NULL){
    if( window->getContactName() == buddy){
      int r = windows.find(window);
      b = buttons.at(r);
      break;
    }
    window = windows.next();
  }
  if( b != NULL && b->currentText() != "Babel Disabled" ){
    qDebug("Translating a message");
    if( b->currentText() == QString("English->French") )
      socket->setType("fr_en");
    if( b->currentText() == QString("English->German") )
      socket->setType("de_en");
    if( b->currentText() == QString("English->Italian") )
      socket->setType("it_en");
    if( b->currentText() == QString("English->Portuguese") )
      socket->setType("pt_en");
    if( b->currentText() == QString("English->Spanish") )
      socket->setType("es_en");
    if( b->currentText() == QString("English->Korean") )
      socket->setType("ko_en");
    if( b->currentText() == QString("English->Japanese") )
      socket->setType("ja_en");
    if( b->currentText() == QString("English->Chinese") )
      socket->setType("zh_en");
    
    if( b->currentText() == "French->English" )
      socket->setType("en_fr");
    if( b->currentText() == "German->English" )
      socket->setType("en_de");
    if( b->currentText() == "Italian->English" )
      socket->setType("en_it");
    if( b->currentText() == "Portuguese->English" )
      socket->setType("en_pt");
    if( b->currentText() == "Spanish->English" )
      socket->setType("en_es");
    if( b->currentText() == "Korean->English" )
      socket->setType("en_ko");
    if( b->currentText() == "Japanese->English" )
      socket->setType("en_ja");
    if( b->currentText() == "Chinese->English" )
      socket->setType("en_zh");


    if( b->currentText() == "French->German" )
      socket->setType("de_fr");
    if( b->currentText() == "German->French" )
      socket->setType("fr_de");
    socket->translate(message, buddy, true);
    return;
  }
  emit ( goingInChatMessage( message, buddy, isAuto ) );
}

/**
 * If the message from buddy needs to be translated set up the socket and start
 * the translation.
 * @param message the text to translate.
 * @param buddy who is going to get the message.
 * @param isAuto wheather this message has been automaticly sent out.
 * @param endIdleNess if we should end idleness when sending out this message.
 */
void BabelPlugin::outChatMessage( QString message, QString buddy, bool isAuto, bool endIdleNess  ){
  Chat *window = windows.first();
  KinkattaComboBox *b = NULL;
  while(window != NULL){
    if( window->getContactName() == buddy){
      int r = windows.find(window);
      if( r == -1 ) qDebug("Can't find window");
      b = buttons.at(r);
      break;
    }
    window = windows.next();
  }
  if( b != NULL && b->currentText() != "Babel Disabled" ){
    qDebug("Translating a message");
    if( b->currentText() == QString("English->French") )
      socket->setType("en_fr");
    if( b->currentText() == QString("English->German") )
      socket->setType("en_de");
    if( b->currentText() == QString("English->Italian") )
      socket->setType("en_it");
    if( b->currentText() == QString("English->Portuguese") )
      socket->setType("en_pt");
    if( b->currentText() == QString("English->Spanish") )
      socket->setType("en_es");
    if( b->currentText() == QString("English->Korean") )
      socket->setType("en_ko");
    if( b->currentText() == QString("English->Japanese") )
      socket->setType("en_ja");
    if( b->currentText() == QString("English->Chinese") )
      socket->setType("en_zh");

    if( b->currentText() == "French->English" )
      socket->setType("fr_en");
    if( b->currentText() == "German->English" )
      socket->setType("de_en");
    if( b->currentText() == "Italian->English" )
      socket->setType("it_en");
    if( b->currentText() == "Portuguese->English" )
      socket->setType("pt_en");
    if( b->currentText() == "Spanish->English" )
      socket->setType("es_en");
    if( b->currentText() == "Korean->English" )
      socket->setType("ko_en");
    if( b->currentText() == "Japanese->English" )
      socket->setType("ja_en");
    if( b->currentText() == "Chinese->English" )
      socket->setType("zh_en");

    if( b->currentText() == "French->German" )
      socket->setType("fr_de");
    if( b->currentText() == "German->French" )
      socket->setType("de_fr");
    socket->translate(message, buddy, false);
    return;
  }
  emit ( goingOutChatMessage( message, buddy, isAuto, endIdleNess ) );
}

// babelplugin.cpp

