/***************************************************************************
                               TextOptionsImp.cpp
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#include "textoptionsimp.h"
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qapplication.h>
#include <qcheckbox.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qspinbox.h>
#include <qfont.h>
#include <qlabel.h>
#include <kcolordialog.h>
#include <kfontdialog.h>

#include <kconfig.h>
#include <kglobal.h>

/**
 * Initializes settings
 * @param parent the parent widget
 * @param name the name of this widget
 */
TextOptionsImp::TextOptionsImp(QWidget *parent, const char *name) : TextOptions ( parent,name,false ){
	i_aimSettings = setup::settings();
  
  connect(chat_color_bname, SIGNAL(clicked()), this, SLOT(changeBuddyNameColor())); 
  connect(chat_color_btext, SIGNAL(clicked()), this, SLOT(changeBuddyTextColor())); 
  connect(chat_color_yname, SIGNAL(clicked()), this, SLOT(changeUserNameColor())); 
  connect(chat_color_ytext, SIGNAL(clicked()), this, SLOT(changeUserTextColor())); 
  connect(chat_color_ybcolor, SIGNAL(clicked()), this, SLOT(changeUserBGColor())); 
  connect(chat_color_bbcolor, SIGNAL(clicked()), this, SLOT(changeBuddyBGColor())); 
  connect(BuddyColorDefault, SIGNAL(clicked()), this, SLOT(setDefaultBuddyColors()));
  connect(MyColorDefault, SIGNAL(clicked()), this, SLOT(setDefaultUserColors()));
}

/**
 * Does nothing.
 */
TextOptionsImp::~TextOptionsImp(){
}

/**
 * Copy the settings from the structs to the widgets.
 */
void TextOptionsImp::updateData(){
  // Get settings.
  KConfig &config = *KGlobal::config();
  config.setGroup("chatwindow");
  i_aimSettings = setup::settings();

  QColor c;
  c.setRgb(0,0,0);
  chat_yourText_color = config.readColorEntry( "chat_yourText_color", &c );
  c.setRgb(0,60,128);
  chat_yourName_color = config.readColorEntry( "chat_yourName_color", &c );
  c.setRgb(0,0,0);
  chat_contactText_color = config.readColorEntry( "chat_contactText_color", &c );
  c.setRgb(128,0,0);
  chat_contactName_color = config.readColorEntry( "chat_contactName_color", &c );
  c.setRgb(255,255,255);
  chat_yourbg_color = config.readColorEntry( "chat_yourbg_color", &c );
  chat_contactbg_color = config.readColorEntry( "chat_contactbg_color", &c );


  QPixmap color;
  color.resize(40,20);
  
  color.fill(chat_yourText_color);
  chat_color_ytext->setPixmap(color);  
  color.fill(chat_yourName_color);
  chat_color_yname->setPixmap(color);
  color.fill(chat_yourbg_color);  // Get settings.
  
  chat_color_ybcolor->setPixmap(color);

  color.fill(chat_contactText_color);
  chat_color_btext->setPixmap(color);  
  color.fill(chat_contactName_color);
  chat_color_bname->setPixmap(color);
  color.fill(chat_contactbg_color);
  chat_color_bbcolor->setPixmap(color);

}

/**
 * Copy the settings from the widgets to the structs.
 */
void TextOptionsImp::getData(){
  // Get settings.
  KConfig &config = *KGlobal::config();
  config.setGroup("chatwindow");

  config.writeEntry( "chat_yourText_color", chat_yourText_color );
  config.writeEntry( "chat_yourName_color", chat_yourName_color );
  config.writeEntry( "chat_contactText_color", chat_contactText_color );
  config.writeEntry( "chat_contactName_color", chat_contactName_color );
  config.writeEntry( "chat_yourbg_color", chat_yourbg_color );
  config.writeEntry( "chat_contactbg_color", chat_contactbg_color );
  
  emit (saveSettings());
}

/**
 * Helper Function.  Gets a color and fulls button 'l' with it.
 * @param c initial color;
 * @param l button to fill.
 */
void TextOptionsImp::getNewColor(QColor &c, QPushButton *l){
  KColorDialog::getColor ( c, this );
  QPixmap color;
  color.resize(40,20);
  color.fill(c);
  l->setPixmap(color);
}

/**
 * Bring up the dialog to change the user text color.
 */
void TextOptionsImp::changeUserTextColor(){
  getNewColor(chat_yourText_color, chat_color_ytext);
}

/**
 * Bring up the dialog to change the contact's text color.
 */
void TextOptionsImp::changeBuddyTextColor(){
  getNewColor(chat_contactText_color, chat_color_btext);
}

/**
 * Bring up the dialog to change the user name text color.
 */
void TextOptionsImp::changeUserNameColor(){
  getNewColor(chat_yourName_color, chat_color_yname);
}

/**
 * Bring up the dialog to change the buddy name text color.
 */
void TextOptionsImp::changeBuddyNameColor(){
  getNewColor(chat_contactName_color, chat_color_bname);
}  

/**
 * Bring up the dialog to change the buddy background color.
 */
void TextOptionsImp::changeBuddyBGColor(){
  getNewColor(chat_contactbg_color, chat_color_bbcolor);
}

/**
 * Bring up the dialog to change the users background color.
 */
void TextOptionsImp::changeUserBGColor(){
  getNewColor(chat_yourbg_color, chat_color_ybcolor);
}

/**
 * Sets up the default buddy colors.
 */
void TextOptionsImp::setDefaultBuddyColors(){
  chat_contactText_color.setRgb(0,0,0);
  chat_contactName_color.setRgb(128,0,0);
  chat_contactbg_color.setRgb(255,255,255);
  
  QPixmap color;
  color.resize(40,20);
  color.fill(chat_contactText_color);
  chat_color_btext->setPixmap(color);  
  color.fill(chat_contactName_color);
  chat_color_bname->setPixmap(color);
  color.fill(chat_contactbg_color);
  chat_color_bbcolor->setPixmap(color);
}

/**
 * Sets up the default user colors.
 */
void TextOptionsImp::setDefaultUserColors(){
  chat_yourText_color.setRgb(0,0,0);
  chat_yourName_color.setRgb(0,60,128);
  chat_yourbg_color.setRgb(255,255,255);
  
  QPixmap color;
  color.resize(40,20);
  color.fill(chat_yourText_color);
  chat_color_ytext->setPixmap(color);  
  color.fill(chat_yourName_color);
  chat_color_yname->setPixmap(color);
  color.fill(chat_yourbg_color);
  chat_color_ybcolor->setPixmap(color);
}

//TextOptionsImp.cpp

