import java.util.*;

import org.kde.qt.*;
import org.kde.koala.*;
/*
    $Id: KFontDialogTest.java,v 1.3 2003/03/08 01:43:02 waba Exp $

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1996 Bernd Johannes Wuebben
                       wuebben@math.cornell.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

*/

/**
 *  Class to test KFontDialog widgets.
 *
 *  This is a translation to java from kfontdialogtest.cpp in the tests library
 *  of kdeui source.
 *
 * @see KFontDialog
 * @see KApplication
 * @see KConfig
 *
 * @author Bernd Johannes Wuebben, java translation Kenneth J. Pouncey, kjpou@hotmail.com
 * @version 0.1
 */
public class KFontDialogTest {

   static String description = "Java KFontDialog test program.";
   static String[][] options = {   };
   static String VERSION = "0.1";

   public static void main(String[] cmdLineArgs) {

      KAboutData aboutData = new KAboutData( "kfontdialogtest", "KFontDialogTest",
         VERSION, description, KAboutData.License_GPL,
         "(c) 2002, Kenneth J. Pouncey");
      aboutData.addAuthor("Kenneth J. Pouncey",null, "kjpou@hotmail.com");
      KCmdLineArgs.init( cmdLineArgs, aboutData );
      KCmdLineArgs.addCmdLineOptions( options ); // Add our own options.

      KApplication app = new KApplication();

      // parse the args
      KCmdLineArgs args = KCmdLineArgs.parsedArgs();

      KConfig aConfig = new KConfig();
      aConfig.setGroup( "KFontDialog-test" );

      // parameters are Font name, Font Point Size, Font Style, Font Italic
      app.setFont(new QFont("Helvetica",12,QFont.Normal,false));
//      app.setFont(new QFont("Times",18,QFont.Bold,true));

      QFont font = aConfig.readFontEntry( "Chosen" );

      int nRet = KFontDialog.getFont(font);

      // return values from KFontDialog
      //    nRet = 1 for OK Button
      //    nRet = 0 for Cancel button

      if (nRet == 1) { // print out font values
         System.out.println("Ok Button pressed from KFontDialog ");
         System.out.println("   Font name selected: " + font.family());
         System.out.println("   Font Point Size selected: " + font.pointSize());
         System.out.println("   Font Bold?: " + font.bold());
         System.out.println("   Font Italic?: " + font.italic());
         System.out.println("   Font Underline?: " + font.underline());
//         System.out.println("   Font Character Set: " + getCharacterSet(font.charSet()));
         System.out.println("   Font raw name selected: " + font.rawName());
      }

      int[] flags = { 0 };

      //Static method for KFontDialog needs to be generated
      nRet = KFontDialog.getFontDiff(font, flags);
      if (nRet == 1) {
         System.out.println("Ok Button pressed from KFontDialog diff dialog ");
         System.out.println("   Font diff flags: " + flags[0]);
         System.out.println("   Font name selected: " + font.family());
         System.out.println("   Font Point Size selected: " + font.pointSize());
         System.out.println("   Font Bold?: " + font.bold());
         System.out.println("   Font Italic?: " + font.italic());
         System.out.println("   Font Underline?: " + font.underline());
         System.out.println("   Font raw name selected: " + font.rawName());
      }

      // This should save off the font chose in the configuration so it can
      //    be read next time.
      aConfig.writeEntry( "Chosen", font,true,false,false );

      aConfig.sync();

      app.exec();
      return;
   }

   /**
    * Returns the string representation of the character set.
    *    Others should be added here.
    */
/*   private static String getCharacterSet (int cs) {

      switch (cs) {

         case QFont.ISO_8859_1 :
            return "ISO_8859_1";
         case QFont.ISO_8859_2 :
            return "ISO_8859_2";
         case QFont.ISO_8859_3 :
            return "ISO_8859_3";
         case QFont.ISO_8859_4 :
            return "ISO_8859_4";
         case QFont.ISO_8859_5 :
            return "ISO_8859_5";
         case QFont.ISO_8859_6 :
            return "ISO_8859_6";
         case QFont.ISO_8859_7 :
            return "ISO_8859_7";
         case QFont.ISO_8859_8 :
            return "ISO_8859_8";
         case QFont.ISO_8859_9 :
            return "ISO_8859_9";
         case QFont.ISO_8859_10 :
            return "ISO_8859_10";
         case QFont.ISO_8859_11 :
            return "ISO_8859_11";
         case QFont.ISO_8859_12 :
            return "ISO_8859_12";
         case QFont.ISO_8859_13 :
            return "ISO_8859_13";
         case QFont.ISO_8859_14 :
            return "ISO_8859_14";
         case QFont.ISO_8859_15 :
            return "ISO_8859_15";

         // more should be added
         default :
            return " other ";

      }
   } */
	static {
		qtjava.initialize();
		kdejava.initialize();
	}

}
