/*
  Gnome applet for Searching the web in a Practical, Outlined and Tidy way
  Copyright (C) 2007 Norberto M. Lopes shelika@mail.telepac.pt
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   
  
  @author: Norberto M. Lopes shelika@mail.telepac.pt
*/
#ifndef GSPOT_CALLBACKS
#define GSPOT_CALLBACKS
#include <string.h>

#include <panel-applet.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <glade/glade.h>
#include <gnome.h>

#define VERSION "0.1.4"

typedef struct {
  GtkWidget *applet;
  GtkWidget *image;
  GtkWidget *frame;
  GtkTooltips *tooltips;
  
  gchar *lang;

  gint size;

  GtkWidget *menu;
  PanelAppletOrient orientation;
} gspotData;

void menu_about_cb (BonoboUIComponent *uic, GtkWidget *applet, const gchar *verbname);
gboolean got_selection(GtkClipboard *clipboard, const gchar *selection, gpointer data);
gboolean button_press_callback(GtkWidget *widget, GdkEventButton *event, gspotData *gspot);
void applet_change_background_cb(PanelApplet *applet, PanelAppletBackgroundType arg1, GdkColor *color, GdkPixmap *pixmap, gspotData *gspot);
void applet_change_size_cb(PanelApplet *applet, gint size, gspotData *gspot);
void gspot_applet_build_menu(gspotData *gspot);

#endif

