//*****************************************************************************
//                                Version.hpp                                 *
//                               -------------                                *
// Description : Version specifier for the GNU Spice GUI application.         *
// Started     : 15/08/2003                                                   *
// Last Update : Refer below                                                  *
// Copyright   : (C) 2003 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef VERSION_HPP
#define VERSION_HPP

#define  APP_NAME       wxT("GNU Spice GUI")
#define  APP_VERSION    wxT("Version 0.9.98 Alpha (14/10/2009)")
#define  APP_COPYRIGHT  wxT("Copyright (c) MSWaters 2003")

#endif // VERSION_HPP

//*****************************************************************************
// THINGS TO DO before v1.0.00 :
//
// (21/08/2009) For GNU-Cap AC analysis where a NPN BJT is used, get an error
//              message (eg. "open circuit: internal node 2") before each line
//              of the results.
//*****************************************************************************
// THINGS TO TEST before v1.0.00 :
//
//*****************************************************************************
// THINGS TO DO in the fullness of time :
//
// (01/10/2009) Installing/uninstalling gSpiceUI is done as root. How can the
//              user's "~/.gspiceui.conf" file be dealt with? Need to determine
//              which user has envoked the root shell.
// (20/08/2009) Tool tips appear in the Nodes list, Components list, text
//              controls notebook and toolbar buttons regardless of the state
//              of the tool tips setting in the preferences dialog. Seems to be
//              a wxWidgets bug.
// (11/06/2009) The NG-Spice Transient analysis cold initial conditions doesn't
//              work. Will need to implement the IC command to zero all nodes
//              voltages.
// (24/02/2009) In the NG-Spice Independent Source configuration dialogue
//              pressing the Clear cannot be un-done with the Cancel button.
// (11/02/2009) There are 2 types of source which may be used : a sweep source
//              and a signal source. Ensure that this distinction is clearly
//              made in the code and the GUI.
// (12/12/2008) The function PrcBase::bLogOutput( ) ends early before all
//              console output is collected.
// (24/11/2008) In PnlValue class shouldn't be allowed to change value or units
//              if a component name hasn't been chosen.
// (14/05/2008) PnlValue class can be set to eg. 0.10 psec by the user but not
//              programmatically, ie. using bSetValue( ).
// (19/02/2008) If gspiceui is exited with gschem open, any unsaved changes in
//              the schematic file are lost.
// (25/10/2007) For NG-Spice simulations if R1 and C1 are connected in parallel
//              and R1 is selected as a test component after a reload operation
//              both R1 and C1 will be highlighted as test components.
// (10/10/2007) Convert NG-Spice phase results from radians to degrees. Refer
//              to section 10.5 Variables -> "units". The SET command doesn't
//              seem to work in batch mode.
// (10/10/2007) In NG-Spice the variable "numdgt" could be useful for setting
//              displayed precision. Refer to section 10.5 Variables.
// (24/08/2007) If the simulation engine is changed a few times the layout of
//              the main frame can get corrupted. Maximize then window gspiceui
//              and things are almost back to normal. Alot less corruption
//              occurs with wxWidgets v2.8.4. Using wxWidgets v2.8.5 changed
//              the simulation engine 4 times and got a segmentation fault.
//              Seems to behave better with wxWidgets v2.8.7, v2.8.9 & v2.8.10
//              but still not perfect.
// (17/07/2007) The transient analysis IC option isn't loaded correctly from
//              the simulation file for NG-Spice.
// (19/06/2007) In FrmMain the run simulation mechanism is evil. It needs a
//              major overhaul. The Stop button doesn't work because the app.
//              stays in the OnSimRun( ) event handler while the simulation
//              runs so no other events are handled until this is exited.
// (07/06/2007) If a current source (as in amperes) is chosen the source setup
//              dialogs displays units of Volts.
// (31/01/2006) While performing a simulation if the gSpiceUI GUI is corrupted
//              it isn't re-drawn until after the simulation is complete. Need
//              wxYield( ) statements in appropriate places to allow the GUI to
//              be updated.
//*****************************************************************************
// GNU-Cap :
//
// (21/04/2005) At times the first result line from a DC analysis is clearly
//              incorrect.
// (20/04/2005) In the AC analysis the following source line is not interpreted
//              correctly: "Vin 2 3 GENERATOR(1) AC 100.00m". The AC magnitude
//              "100.00m" is not interpreted as "0.1"; replace it with "0.1"
//              and everything works OK.
// (29/03/2004) The PRINT command doesn't produce a label for the independent
//              parameter ie. temperature or OP, voltage for DC.
//*****************************************************************************
// NG-Spice :
//
// (06/10/2009) NUMDGT should set the number digits to print when printing
//              tables of data. Doesn't work in batch mode.
// (11/05/2007) PRINT statement parser is broken. Eg. PRINT TRAN V(0,1) V(0,2)
//              is interpreted as one parameter -V(1)-V(2) instead of two; in
//              contrast PRINT TRAN V(1,0) V(2,0) is interpreted correctly. In
//              addition eg. PRINT AC VDB(0,1) wont run at all.
//              Notes : The .PRINT statement parsing starts in fixem( char * )
//                      (src/frontend/dotcards.c) which calls gettoks( char * )
//                      which calls gettok( char ** ) (../src/misc/string.c).
//                      I think the bug is in gettok( char ** ) or how it is
//                      used by gettoks( char * ).
//*****************************************************************************
// GWave :
//
// (29/03/2004) GWave can't handle the banner that Gnu-CAP includes in it's
//              output.
//*****************************************************************************
// GNetList :
//
// (19/07/2005) If a relative model file path specified in schematic file the
//              path is regarded as relative to the CWD not the schematic file
//              path which would be more logical.
// (12/04/2005) When schem. file imported via command line "gnetlist.log" left
//              in gspiceui bin directory. When schem. file imported via GUI
//              "gnetlist.log" left in schematic directory.
//*****************************************************************************
// wxWidgets Library Bugs :
//
// (03/09/2009) v2.8.10 : Class wxToolTip seems to be broken ie. can't globally
//                        enable/disable tooltips or set the tooltip delay.
// (07/09/2007) v2.8.5 : Cannot set the font in the choice control in the
//                       PnlValue class when no file loaded at startup. It
//                       should inherit the font from it's parent; every other
//                       control does. This seems to be bug in wxWidgets v2.8.5
//                       and v2.6.3.
// (28/05/2007) v2.8.3 : In the class PnlValue class and function DoLayout( )
//                       wxWidgets ignores the request to vertically align the
//                       StaticText object.
// (04/02/2007) v2.8.3 : The class wxFileName has an undocumented function
//                       SetPath( ).
// (12/04/2005) v2.5.4 : "make uninstall" does nothing.
// (06/04/2005) v2.5.2 : When the wxFrame is resized wxStatusBar isn't.
// (01/10/2004) v2.5.2 : No mention of wxControl constructor in documentation.
// (18/09/2004) v2.5.2 : In the class wxTextCtrl style setting wxTE_RIGHT is
//                       ignored in Create( ) function.
// (13/08/2004) v2.4.2 : In class wxFileDialog styles can only be set in the
//                       constructor. The method SetStyle( ) does nothing.
// (21/02/2004) v2.4.2 : In the class wxTextFile function IsOpened( ) returns
//                       TRUE after Open( ) but FALSE after Create( ).
// (19/02/2004) v2.4.2 : In the class wxSpinCtrl when using SetValue( (int) 0 )
//                       for initialization the spin control is left blank.
// (17/11/2003) v2.4.1 : In class wxFileDialog wildcards can only be set in the
//                       constructor. The method SetWildcard( ) is not properly
//                       implemented. See constructor in src/generic/filedlgg.cpp
//                       and set method in include/wx/generic/filedlgg.h.
//*****************************************************************************
