//*****************************************************************************
//                              CmdNgSpiceTR.hpp                              *
//                             ------------------                             *
//  Description : This class contains values associated with the NG-Spice     *
//                TRANSIENT command. It inherits from the class CmdBase.      *
//  Started     : 15/10/2007                                                  *
//  Last Update : 15/01/2008                                                  *
//  Copyright   : (C) 2007 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPICETR_HPP
#define CMDNGSPICETR_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "TypeDefs.hpp"
#include "base/CmdBase.hpp"
#include "utility/ConvertType.hpp"

// Local Macro and Constant Declarations

//*****************************************************************************

struct CmdNgSpiceTR : public CmdBase
{
  public :

    float       m_fStart;    // The sweep start value
    float       m_fStop;     // The sweep stop  value
    float       m_fStep;     // The sweep step  value
    eInitCType  m_eInitC;    // The initial conditions

              CmdNgSpiceTR( void );
    virtual  ~CmdNgSpiceTR( );

    bool  bClear( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    wxString & operator = ( const wxString & ros )
                { *((wxString *) this) = ros; return( *((wxString *) this) ); }
};

//*****************************************************************************

#endif // CMDNGSPICETR_HPP
