/* gnobog_bookmarks.h
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOBOG_BOOKMARKS_H
#define GNOBOG_BOOKMARKS_H

#include <config.h>
#include <gnome.h>

/*
 * Gnobog Bookmarks Entry Definitions
 */

/* The different kinds of bookmark entries */
typedef enum _GnobogBookmarksNodeType { 
  UNKNOWN_ENTRY,
  TITLE,
  FOLDER,
  BOOKMARK,
  ALIAS,
  SEPARATOR
} GnobogBookmarksNodeType;

/*
 * Gnobog Bookmarks Object Declarations
 */

#define GNOBOG_TYPE_BOOKMARKS          (gnobog_bookmarks_get_type ())
#define GNOBOG_BOOKMARKS(obj)          GTK_CHECK_CAST (obj, GNOBOG_TYPE_BOOKMARKS, GnobogBookmarks)
#define GNOBOG_BOOKMARKS_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, GNOBOG_TYPE_BOOKMARKS, GnobogBookmarksClass)
#define GNOBOG_IS_BOOKMARKS(obj)       GTK_CHECK_TYPE (obj, GNOBOG_TYPE_BOOKMARKS)


/* File Types Handled */
typedef enum { 
  UNKNOWN_FILEFORMAT,
  GNOBOG_FILEFORMAT,
  NETSCAPE4_FILEFORMAT,
  MOZILLA_FILEFORMAT,
  GALEON_FILEFORMAT,
  NAUTILUS_FILEFORMAT,
  KONQUEROR_FILEFORMAT,
  OPERA_FILEFORMAT
} GnobogBookmarksFileFormat;

/* Friendly Browsers */
typedef enum { 
  DEFAULT_BROWSER,
  NETSCAPE_BROWSER,
  MOZILLA_BROWSER,
  GALEON_BROWSER,
  GNOME_HANDLER_BROWSER,
  NAUTILUS_BROWSER,
  KONQUEROR_BROWSER,
  OPERA_BROWSER,
  LYNX_BROWSER,
  LINKS_BROWSER,
  GFTP_BROWSER,
  NCFTP_BROWSER,
  LFTP_BROWSER
} GnobogBrowser;

/* Insert Mode definitions */
typedef enum { 
  INSERT_DEFAULT_MODE,
  INSERT_AFTER,
  INSERT_BEFORE,
  INSERT_INTO
} GnobogBookmarksInsertMode;

/* Bookmarks nodes */
typedef GNode*  GnobogBookmarksNode;

typedef struct _GnobogBookmarksNodeWithRow GnobogBookmarksNodeWithRow;
struct _GnobogBookmarksNodeWithRow {
  gint                  row;
  GnobogBookmarksNode   node;
};

/* Gnobog Bookmarks Object Definitions */
typedef struct _GnobogBookmarks GnobogBookmarks;
struct _GnobogBookmarks {
  GtkObject                 gtk_object;
  
  gchar*                    title;                      /* Bookmarks title  */
  gchar*                    description;                /* Bookmarks description */
  gchar*                    filename;                   /* Bookmarks filename */
  GnobogBookmarksFileFormat format;                     /* Bookmarks type file */
  GnobogBookmarksNode       node;                       /* Root node of bookmarks */
  GHashTable*               alias_hash_table;           /* Alias Map */
  gboolean                  readonly;                   /* TRUE if file is 'read only' */
  gboolean                  modified;                   /* TRUE if bookmarks has been modified */
  GnobogBookmarksInsertMode insert_default_mode;        /* Insert mode preferences */
  GnobogBookmarksInsertMode folder_insert_default_mode; /* Insert mode preferences */
};

/* Gnobog Bookmarks Object Class Definitions */
typedef struct _GnobogBookmarksClass GnobogBookmarksClass;
struct _GnobogBookmarksClass {
  GtkObjectClass             parent_class;

  void (*list_created)      (GnobogBookmarks* bookmarks, 
                             GnobogBookmarksNode anchor_node, 
                             GnobogBookmarksInsertMode mode, 
                             GList* list);

  void (*list_modified)     (GnobogBookmarks* bookmarks, 
                             GList* list);

  void (*list_deleted)      (GnobogBookmarks* bookmarks, 
                             GList* list);

  void (*bookmarks_cleared) (GnobogBookmarks* bookmarks);
};

/* --------------------------------------------------------------------
 * Public methods
 * --------------------------------------------------------------------
 */

/*  GTK Object System */
GtkType                    gnobog_bookmarks_get_type
                                           (void);

/* Bookmarks creation and destruction */
GnobogBookmarks* gnobog_bookmarks_new  /* Avoid using this one... */         
                                 (void);
GnobogBookmarks* gnobog_bookmarks_new_with_title           
                                 (gchar* title,
                                  gchar* description);
GnobogBookmarks* gnobog_bookmarks_new_from_bookmarks
                                 (GnobogBookmarks* bookmarks);
GnobogBookmarks* gnobog_bookmarks_new_from_file
                                 (gchar* filename);
void             gnobog_bookmarks_destroy       
                                 (GtkObject* bookmarks);
gboolean         gnobog_bookmarks_save_file           
                                 (GnobogBookmarks* bookmarks);
gboolean         gnobog_bookmarks_save_as_file       
                                 (GnobogBookmarks* bookmarks, 
                                  gchar* filename, 
                                  GnobogBookmarksFileFormat type);
gboolean         gnobog_bookmarks_save_copy_as_file   
                                 (GnobogBookmarks* bookmarks, 
                                  gchar* filename, 
                                  GnobogBookmarksFileFormat type);

/* Bookmarks Attributes Manipulation */
gchar*                     gnobog_bookmarks_get_title       
                                           (GnobogBookmarks* bookmarks);
void                       gnobog_bookmarks_set_title       
                                           (GnobogBookmarks* bookmarks,
                                            gchar* title);
gchar*                     gnobog_bookmarks_get_description       
                                           (GnobogBookmarks* bookmarks);
void                       gnobog_bookmarks_set_description       
                                           (GnobogBookmarks* bookmarks,
                                            gchar* description);
gboolean                   gnobog_bookmarks_is_modified   
                                           (GnobogBookmarks* bookmarks);
gboolean                   gnobog_bookmarks_is_readonly   
                                           (GnobogBookmarks* bookmarks);
void                       gnobog_bookmarks_set_readonly  
                                           (GnobogBookmarks* bookmarks, 
                                            gboolean readonly);
GnobogBookmarksInsertMode  gnobog_bookmarks_get_insert_default_mode 
                                           (GnobogBookmarks* bookmarks);
void                       gnobog_bookmarks_set_insert_default_mode     
                                           (GnobogBookmarks* bookmarks, 
                                            GnobogBookmarksInsertMode mode);
GnobogBookmarksInsertMode  gnobog_bookmarks_get_folder_insert_default_mode      
                                           (GnobogBookmarks* bookmarks);
void                       gnobog_bookmarks_set_folder_insert_default_mode      
                                           (GnobogBookmarks* bookmarks,
                                            GnobogBookmarksInsertMode mode);
gchar*                     gnobog_bookmarks_get_filename 
                                           (GnobogBookmarks* bookmarks);
void                       gnobog_bookmarks_set_filename 
                                           (GnobogBookmarks* bookmarks,
                                            gchar* filename);
GnobogBookmarksFileFormat  gnobog_bookmarks_get_file_format 
                                           (GnobogBookmarks* bookmarks);

/* Bookmarks Node Attributes Manipulations */
GnobogBookmarksNodeType  gnobog_bookmarks_node_get_type                               
                                         (GnobogBookmarksNode node);
gchar*                   gnobog_bookmarks_node_get_name                               
                                         (GnobogBookmarksNode node);
gchar*                   gnobog_bookmarks_node_get_location                   
                                         (GnobogBookmarksNode node);
gchar*                   gnobog_bookmarks_node_get_description                
                                         (GnobogBookmarksNode node);
GTime                    gnobog_bookmarks_node_get_creation_time              
                                         (GnobogBookmarksNode node);
GTime                    gnobog_bookmarks_node_get_modification_time  
                                         (GnobogBookmarksNode node);
GTime                    gnobog_bookmarks_node_get_visit_time         
                                         (GnobogBookmarksNode node);
gboolean                 gnobog_bookmarks_node_get_folder_state               
                                         (GnobogBookmarksNode node);
GList*                   gnobog_bookmarks_node_get_alias_list         
                                         (GnobogBookmarksNode node);
gboolean                 gnobog_bookmarks_node_is_folder_open         
                                         (GnobogBookmarksNode node);
gboolean                 gnobog_bookmarks_node_have_aliases                   
                                         (GnobogBookmarksNode node);

/* Inserting Bookmarks Node  */
GnobogBookmarksNode  gnobog_bookmarks_node_insert_new             
                                     (GnobogBookmarks* bookmarks, 
                                      GnobogBookmarksNode anchor_node, 
                                      GnobogBookmarksInsertMode mode, 
                                      GnobogBookmarksNodeType type, 
                                      gchar* name, 
                                      gchar* location, 
                                      gchar* description);
GnobogBookmarksNode  gnobog_bookmarks_node_insert_new_separator             
                                     (GnobogBookmarks* bookmarks, 
                                      GnobogBookmarksNode anchor_node, 
                                      GnobogBookmarksInsertMode mode);
void                 gnobog_bookmarks_list_copy_from              
                                     (GnobogBookmarks* bookmarks, 
                                      GnobogBookmarks* source_bookmarks, 
                                      GnobogBookmarksNode anchor_node, 
                                      GnobogBookmarksInsertMode mode, 
                                      GList* list);
void                 gnobog_bookmarks_list_move_from              
                                     (GnobogBookmarks* bookmarks, 
                                      GnobogBookmarks* source_bookmarks, 
                                      GnobogBookmarksNode anchor_node, 
                                      GnobogBookmarksInsertMode mode, 
                                      GList* list);

/* Modifying Bookmarks Node */
void  gnobog_bookmarks_node_modify                 
                      (GnobogBookmarks* bookmarks, 
                       GnobogBookmarksNode node, 
                       gchar* name, 
                       gchar* location, 
                       gchar* description);

/* Bookmarks Node Manipulation */
void  gnobog_bookmarks_list_copy                   
                      (GnobogBookmarks* bookmarks, 
                       GnobogBookmarksNode anchor_node, 
                       GnobogBookmarksInsertMode mode, 
                       GList* list);
void  gnobog_bookmarks_list_move                   
                      (GnobogBookmarks* bookmarks, 
                       GnobogBookmarksNode anchor_node, 
                       GnobogBookmarksInsertMode mode, 
                       GList* list);

/* Bookmarks Node Destruction */
void  gnobog_bookmarks_list_delete         
                      (GnobogBookmarks* bookmarks, 
                       GList* list);
void  gnobog_bookmarks_clear                               
                      (GnobogBookmarks* bookmarks);

/* Miscellaneous */
GList*  gnobog_bookmarks_node_get_child_list         
                        (GnobogBookmarks* bookmarks, 
                         GnobogBookmarksNode node);
GList*  gnobog_bookmarks_get_list                    
                        (GnobogBookmarks* bookmarks);
GList*  gnobog_bookmarks_get_folder_content  
                        (GnobogBookmarks* bookmarks, 
                         GnobogBookmarksNode bookmarks_node);

/* Bookmarks node advanced manipulation */
gchar*                     gnobog_bookmarks_node_get_path                       
                                           (GnobogBookmarks* bookmarks, 
                                            GnobogBookmarksNode node);
GList*                     gnobog_bookmarks_get_redundant                       
                                           (GnobogBookmarks* bookmarks);
void                       gnobog_bookmarks_node_view_in_browser        
                                           (GnobogBookmarks* bookmarks, 
                                            GnobogBookmarksNode node,
					    GnobogBrowser browser,
                                            gboolean open_new_window);
/*  void                       gnobog_bookmarks_node_auto_alias              */
/*                                             (GnobogBookmarks* bookmarks,  */
/*                                              GnobogBookmarksNode node); */
/*  void                       gnobog_bookmarks_list_auto_alias              */
/*                                             (GnobogBookmarks* bookmarks,  */
/*                                              GList* list); */

#endif
