#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <sys/wait.h>

#include "defines.h"

#ifdef HAVE_GNOME
#include "applet.h"

extern GtkWidget *applet;
#endif

#include "conf.h"
#include "actions.h"
#include "gui.h"
#include "ppp_info.h"

extern int check_timeout;
extern int connecting_tout;
extern int state;
extern char last_choice[FILENAME_MAX];
extern gchar modem_tty[FILENAME_MAX];
extern gchar lock_file[FILENAME_MAX];
extern gchar connect_cmd[FILENAME_MAX];
extern gchar disconnect_cmd[FILENAME_MAX];

/* was it gkdial who started the connection ? is this
 the first time we check if the connection is up ? */
guint was_gkdial = FALSE;
guint first_time = TRUE;

int lights_timeout = 0;

#ifdef HAVE_GNOME
extern int is_applet;
#endif

int update_lights (gpointer data)
{
  static int last_in_bytes = 0;
  static int last_out_bytes = 0;

  int in;
  int out;

  int in_bps;
  int out_bps;

  int in_on = FALSE, out_on = FALSE;

  get_stats(&in, &out);
  
  in_bps = in - last_in_bytes;
  out_bps = out - last_out_bytes;

  if (in_bps > 0)
    in_on = TRUE;

  if (out_bps > 0)
    out_on = TRUE;

  set_in_out (in_on, out_on);

#ifdef HAVE_GNOME
  if (is_applet)
    app_set_in_out (in_on, out_on);
#endif
  
  last_in_bytes = in;
  last_out_bytes = out;

  return FALSE;
}

/*
  This is the main loop, it is run every 1000 miliseconds and
  updates the program
*/
int check_connection (gpointer data)
{
  /* number of bytes entering iface */
  int tin = 0, 
    tout = 0;
  
  /* 
     number of bytes that entered iface 
     last time
  */
  static int lastin = 0,
    lastout = 0;

  /* 
     number of bytes that were counted
     for the iface while off
  */
  static int tin_while_off = 0,
    tout_while_off = 0;
  int ppp_on;

  /* gets some information */
  ppp_on = get_stats(&tin, &tout);

  if (is_connected ())
    {
      /* 
	 values of tin and tout == 0 means the ppp interface
	 is still not up but it seems that, for some systems,
	 this is never true so, if the values for tin and tout 
	 are not changed from when the conection was not up is 
	 the same now, we'll consider it to be down too
      */
      if (!ppp_on || (tin == 0 && tout == 0)
	  || (tin_while_off == tin && tout_while_off == tout))
	{
	  lastin = lastout = 0;
	  if (state != CONNECTING)
	    {
	      /* It was not gkdial who did it... */
	      was_gkdial = FALSE;
	      gk_status_set_connecting (_("unknown"));
	    }
	}
      else
	{
	  if (state != CONNECTED)
	    gk_status_set_connected();
	  /* 
	     adds a timeout to update the lights independently
	  */
	  lights_timeout = gtk_timeout_add (200, update_lights, NULL);
	}

      /* updates some connection info */
      update_ctime(); // connection time
      if (!first_time)
	update_bps(tin - lastin, tout - lastout);
    }
  else if (state != DISCONNECTED)
    {
      /* gets tin and tout values while off */
      get_stats (&tin_while_off, &tout_while_off);
      if (!was_gkdial)
	state = DISCONNECTED;
      gk_status_set_disconnected();
      state = DISCONNECTED;
    }

  lastin = tin;
  lastout = tout;

  first_time = FALSE;

  return 1;
}

/*
  Does what's needed to set the connection status to connected
*/
void gk_status_set_connected ()
{
  /* set state to CONNECTED */
  state = CONNECTED;

  gtk_statusbar_pop (GTK_STATUSBAR(statusbar), context);
  gtk_statusbar_push (GTK_STATUSBAR(statusbar), context,
		      _(" Status: connected."));

#ifdef HAVE_GNOME
  if (is_applet)
    gk_applet_set_state (PIX_ON);
#endif

  gk_set_state (PIX_ON);

  get_connect_time(TRUE);

}


/* 
   sets connection status to disconnected
*/
void gk_status_set_disconnected ()
{
  /* 
     if connection was up before, it was probably lost
     (the user did not want to close the connection)
     we'll then alert the user about this
  */
  if ((state == CONNECTED || state == CONNECTING) && was_gkdial)
    {
      gk_diag (_("The connection was lost or a connection\n"
		 "being tried was not successful.\n"
		 "Click \"Connect!\" to reconnect."));
      was_gkdial = FALSE;
    }

#ifdef HAVE_GNOME
  if (is_applet)
    gk_applet_set_state (PIX_OFF);
#endif

  gk_set_state (PIX_OFF);
  gtk_statusbar_pop (GTK_STATUSBAR(statusbar), context);
  gtk_statusbar_push (GTK_STATUSBAR(statusbar), context,
		      _(" Status: disconnected."));
  
  if (lights_timeout)
    gtk_timeout_remove (lights_timeout);


  /* turn off the lights (they remain lit some times) */
  set_in_out (FALSE, FALSE);

#ifdef HAVE_GNOME
  if (is_applet)
    app_set_in_out (FALSE, FALSE);
#endif

}  

/*
  tells the program that we're now connecting, stops the
  main looping and enables check_connect timeout
*/
void gk_status_set_connecting (gchar *chosen_peer)
{
  printf(_("GkDial: Connecting: %s\n"), chosen_peer);
  
  state = CONNECTING;

  get_connect_time(TRUE);

#ifdef HAVE_GNOME
  if (is_applet)
    gk_applet_set_state (PIX_WAITING);
#endif
  
  gk_set_state (PIX_WAITING);
  
  gtk_statusbar_pop (GTK_STATUSBAR(statusbar), context);
  gtk_statusbar_push (GTK_STATUSBAR(statusbar), context,
		      _(" Status: connecting..."));

}  

/*
  Connects to the internet running the command supplied by
  the user, plus the name of the peer selected in main_combo
*/
void gk_connect (GtkWidget *button, gpointer data)
{
  gchar* chosen_peer;
  gchar command[FILENAME_MAX];

  /* checks to see if configuration was made already */
  if (!getvalue("connect_cmd=", NULL))
    {
      gk_diag (_("You've not done your configuration\n"
		 "properly yet, I don't know wich command\n"
		 "I should run nor the lock file I should\n"
		 "monitor... Please set these values using\n"
		 "the 'Preferences' menu."));
      return;
    }

  chosen_peer = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(main_combo)->entry));

  strcpy (last_choice, chosen_peer);
  conf_write();

  was_gkdial = TRUE;

  gk_status_set_connecting(chosen_peer);

  sprintf (command, "%s %s", connect_cmd, chosen_peer);

  gk_exec (command);

}

/*
  runs the command the user defined to disconnect
*/
void gk_disconnect (GtkWidget *button, gpointer data)
{
  gtk_timeout_remove (check_timeout);
  gtk_timeout_remove (connecting_tout);

  /* calls the command used for disconnection */
  gk_exec (disconnect_cmd);

  /* this shows that gkdial was the responsible for the connection
     bring closed */
  state = DISCONNECTING;

  /* pops the statusbar's msg */
  gtk_statusbar_pop (GTK_STATUSBAR(statusbar), context);
  /* put in a new message */
  gtk_statusbar_push (GTK_STATUSBAR(statusbar), context,
		      _(" Disconnecting..."));

  printf(_("GkDial: Disconnecting...\n"));

  /* we'll wait some little time for the connection to get closed */
  usleep(1200);

  check_timeout = gtk_timeout_add (CHK_TIMEOUT, check_connection, NULL);
}

/*
  executes a command
*/
void gk_exec (gchar *command)
{
  gchar **gk_args;
  gchar tmp[FILENAME_MAX],
    *c;
  gchar error_msg[1024];
  int i;
  pid_t pid;

  /* 
     we'll allocate memory as needed, here we get the first
     bytes we need 
  */
  gk_args = g_malloc (sizeof (gchar*)*2);
  gk_args[0] = g_malloc (sizeof(gchar)*FILENAME_MAX);
  gk_args[1] = NULL;

  /* 
     we'll not use 'command' for strtok as we don't want
     it to be modified
  */
  strncpy (tmp, command, FILENAME_MAX);
  c = strtok (tmp, " ");
  strncpy (gk_args[0], c, FILENAME_MAX);
  
  fprintf (stderr, _("Calling: %s "), gk_args[0]);

  for (i = 1 ; (c = strtok (NULL, " ")) != NULL ; i++)
    {
      /* 
	 let's fill the arguments, we'll add one last NULL
	 because execv() needs it
      */
      gk_args = g_realloc (gk_args, sizeof(gchar*)*(i+2));
      gk_args[i] = g_malloc (sizeof(gchar)*FILENAME_MAX);
      gk_args[i+1] = NULL;
      strncpy (gk_args[i], c, FILENAME_MAX);
      fprintf(stderr, "%s ", gk_args[i]);
    }

  fprintf (stderr, "\n");
  
  pid = fork();

  /* calls the command used to connect to the internet */
  switch (pid)
    {
    case 0:
      if (execvp(gk_args[0], gk_args) == -1)
	{
	  printf("%s\n", gk_args[0]);
	  sprintf (error_msg, _("Error! Could not execute %s."),
		   gk_args[0]);
	  gk_diag (_(error_msg));
	  gk_disconnect(NULL, NULL);
	}
      break;
    case -1:
      gk_diag (_("Error, could not fork()."));
      break;
    default:
      wait(NULL);
    }

  sleep(1);

}
 
/*
  insert the options to the main_combo box, options are the
  files found in /etc/ppp/peers
*/
gint combo_insert_options (GtkWidget *combo_box)
{
  DIR *peers_dir;
  struct dirent *files_peers;
  GList *peers_list = NULL;
  gchar *tmp= NULL;
  int peers_found = 0;
    
  peers_dir = opendir (PEERS_DIR);
  if (!peers_dir)
    {
      fprintf (stderr, _("Unable to open directory %s...\n"
			 "You need read acces to this directory at least\n"
			 "to run this program, try adding your user to\n"
			 "the `dip' group. "), PEERS_DIR);
      exit (1);
    }	      
    

#ifdef HAVE_GNOME
  if (is_applet)
    {
      applet_widget_register_callback_dir (APPLET_WIDGET(applet), 
					   "connections",
					   _("Select another peer..."));
    }
#endif

  while ((files_peers = readdir (peers_dir)))
    {
      if (((files_peers->d_name[0]) != '.'))
	{
	  tmp = strrchr (files_peers->d_name, '~');
	  if (tmp)
	    continue;

	  peers_list = g_list_append (peers_list, (gchar*) files_peers->d_name);
#ifdef HAVE_GNOME
	  if (is_applet)
	    {
	      gchar miname[FILENAME_MAX];

	      sprintf (miname, "connections/%s", files_peers->d_name);

	      applet_widget_register_callback (APPLET_WIDGET(applet),
					       miname,
					       (gchar*)files_peers->d_name,
					       combo_set_selection,
					       files_peers->d_name);
	    }
#endif

	  peers_found++;
	}
    }

  if (peers_found)
    {
      gtk_combo_set_popdown_strings (GTK_COMBO(combo_box), peers_list);
      if (getvalue("last_choice=", last_choice))
	{
	  combo_set_selection (NULL, (gpointer)last_choice);
	}
    }
  fflush(stdout);

  /* well, this is not really right but... FIXME! +)=) */
#ifdef HAVE_GNOME
	  if (is_applet)
	    {
	      /* an about item... */
	      applet_widget_register_callback (APPLET_WIDGET(applet), "about",
					       _("About..."), gkdial_about,
					       NULL);
	    }
#endif

  return peers_found;
}

void combo_set_selection (GtkWidget *w, gpointer choice)
{
  gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(main_combo)->entry), 
		      (gchar*)choice);
}

void widget_quit (GtkWidget *widget, gpointer data)
{
  if (data != NULL)
    {
      gtk_widget_hide(data);
    }
  else
    {
      gtk_widget_hide(widget);
    }
}

void delete_event (GtkWidget *main_window, gpointer data)
{
  printf(_("GkDial: See You!!\n"));
  gtk_main_quit();
}    

void force_quit (GtkWidget *main_window, gpointer data)
{
  gtk_exit (1);
}
