/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include <gtk/gtk.h>

#include "ginspector.h"


int
main (int   argc,
      char *argv[])
{
  gtk_init (&argc, &argv);

  g_inspector_init (&argc, &argv);
  g_inspector_activate ();

#if 0
  {
    GtkWidget *window;
    GtkWidget *label;

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

    label = gtk_label_new ("Hello, World!");
    gtk_container_add (GTK_CONTAINER (window), label);

    gtk_widget_show_all (window);
  }
#else
  {
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *label;
    int i;

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), vbox);

    for (i = 0; i < 5; ++i) {
      label = gtk_button_new_with_label ("Label");
      gtk_box_pack_start_defaults (GTK_BOX (vbox), label);
    }

    gtk_widget_show_all (window);


    {
      g_inspector_invoke_procedure_by_name ("pickup-instance",
					    vbox,
					    NULL);
    }
  }
#endif

  gtk_main ();


  return 0;
}
