/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspectorpanel.h"


enum {
  UPDATE,
  LAST_SIGNAL
};

enum {
  PROP_0,
  PROP_VALUE,
};


static void g_inspector_panel_set_property (GObject      *object,
					    guint         prop_id,
					    const GValue *value,
					    GParamSpec   *pspec);
static void g_inspector_panel_get_property (GObject      *object,
					    guint         prop_id,
					    GValue       *value,
					    GParamSpec   *pspec);
static void g_inspector_panel_size_request  (GtkWidget      *widget,
					     GtkRequisition *requisition);
static void g_inspector_panel_size_allocate (GtkWidget      *widget,
					     GtkAllocation  *allocation);



static guint inspector_panel_signals[LAST_SIGNAL] = { 0 };


G_DEFINE_TYPE (GInspectorPanel, g_inspector_panel, GTK_TYPE_BIN);


static void
g_inspector_panel_class_init (GInspectorPanelClass *klass)
{
  GObjectClass *gobject_class;
  GtkBinClass *bin_class;
  GtkWidgetClass *widget_class;
  GInspectorPanelClass *inspector_panel_class;

  gobject_class = G_OBJECT_CLASS (klass);
  bin_class = (GtkBinClass*) klass;
  widget_class = (GtkWidgetClass*) klass;
  inspector_panel_class = (GInspectorPanelClass*) klass;

  gobject_class->set_property = g_inspector_panel_set_property;
  gobject_class->get_property = g_inspector_panel_get_property;
  widget_class->size_request = g_inspector_panel_size_request;
  widget_class->size_allocate = g_inspector_panel_size_allocate;

  inspector_panel_class->update = NULL;


  inspector_panel_signals[UPDATE]
     = g_signal_new ("update",
                     G_OBJECT_CLASS_TYPE (gobject_class),
                     G_SIGNAL_RUN_FIRST,
                     G_STRUCT_OFFSET (GInspectorPanelClass, update),
                     NULL, NULL,
                     g_cclosure_marshal_VOID__VOID,
                     G_TYPE_NONE, 0);
}

static void
g_inspector_panel_init (GInspectorPanel *inspector_panel)
{
  inspector_panel->element_type = G_INSPECTOR_ELEMENT_TYPE_NONE;
  inspector_panel->element = NULL;
}

static void
g_inspector_panel_set_property (GObject      *object,
				guint         prop_id,
				const GValue *value,
				GParamSpec   *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
g_inspector_panel_get_property (GObject    *object,
				guint       prop_id,
				GValue     *value,
				GParamSpec *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
g_inspector_panel_size_request (GtkWidget      *widget,
				GtkRequisition *requisition)
{
  GtkWidget *child;
  gint tmp_width;
  gint tmp_height;


  child = GTK_BIN (widget)->child;


  if ((child != NULL) &&
      GTK_WIDGET_VISIBLE (child))
    {
      GtkRequisition child_requisition;

      gtk_widget_size_request (child, &child_requisition);

      tmp_width  = child_requisition.width;
      tmp_height = child_requisition.height;
    }
  else
    {
      tmp_width  = 0;
      tmp_height = 0;
    }

  requisition->width  = tmp_width;
  requisition->height = tmp_height;
}

static void
g_inspector_panel_size_allocate (GtkWidget      *widget,
				 GtkAllocation  *allocation)
{
  GtkWidget *child;

  widget->allocation = *allocation;

  child = GTK_BIN (widget)->child;

  if ((child != NULL) &&
      GTK_WIDGET_VISIBLE (child))
    {
      GtkAllocation child_allocation;

      child_allocation.x      = allocation->x;
      child_allocation.y      = allocation->y;
      child_allocation.width  = allocation->width;
      child_allocation.height = allocation->height;

      gtk_widget_size_allocate (child, &child_allocation);
    }
}


void
g_inspector_panel_update (GInspectorPanel *inspector_panel)
{
  g_return_if_fail (inspector_panel != NULL);
  g_return_if_fail (G_IS_INSPECTOR_PANEL (inspector_panel));


  g_signal_emit (inspector_panel, inspector_panel_signals[UPDATE], 0);
}
