/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "changednotifypair.h"



ChangedNotifyPair *
changed_notify_pair_new (GObject *changed_object,
			 GObject *notify_object)
{
  ChangedNotifyPair *changed_notify_pair;


  changed_notify_pair = g_new (ChangedNotifyPair, 1);


  changed_notify_pair->changed_object = changed_object;
  changed_notify_pair->changed_handler_id = 0;

  changed_notify_pair->notify_object = notify_object;
  changed_notify_pair->notify_handler_id = 0;

  changed_notify_pair->ref_count = 0;


  return changed_notify_pair;
}

static void
changed_notify_pair_destroy (ChangedNotifyPair *changed_notify_pair)
{
  g_return_if_fail (changed_notify_pair != NULL);
  g_return_if_fail (changed_notify_pair->ref_count == 0);

  g_return_if_fail (changed_notify_pair->changed_object == NULL);
  g_return_if_fail (changed_notify_pair->changed_handler_id == 0);
  g_return_if_fail (changed_notify_pair->notify_object == NULL);
  g_return_if_fail (changed_notify_pair->notify_handler_id == 0);


  g_free (changed_notify_pair);
}

void
changed_notify_pair_ref (ChangedNotifyPair *changed_notify_pair)
{
  g_return_if_fail (changed_notify_pair != NULL);


  changed_notify_pair->ref_count += 1;
}

void
changed_notify_pair_unref (ChangedNotifyPair *changed_notify_pair)
{
  g_return_if_fail (changed_notify_pair != NULL);


  changed_notify_pair->ref_count -= 1;

  if (changed_notify_pair->ref_count == 0)
    {
      changed_notify_pair_destroy (changed_notify_pair);
    }
}


void
changed_notify_pair_block_changed_handler (ChangedNotifyPair *changed_notify_pair)
{
  g_return_if_fail (changed_notify_pair != NULL);


  g_signal_handler_block (changed_notify_pair->changed_object,
			  changed_notify_pair->changed_handler_id);
}

void
changed_notify_pair_unblock_changed_handler (ChangedNotifyPair *changed_notify_pair)
{
  g_return_if_fail (changed_notify_pair != NULL);


  g_signal_handler_unblock (changed_notify_pair->changed_object,
			    changed_notify_pair->changed_handler_id);
}

void
changed_notify_pair_block_notify_handler (ChangedNotifyPair *changed_notify_pair)
{
  g_return_if_fail (changed_notify_pair != NULL);


  g_signal_handler_block (changed_notify_pair->notify_object,
			  changed_notify_pair->notify_handler_id);
}

void
changed_notify_pair_unblock_notify_handler (ChangedNotifyPair *changed_notify_pair)
{
  g_return_if_fail (changed_notify_pair != NULL);


  g_signal_handler_unblock (changed_notify_pair->notify_object,
			    changed_notify_pair->notify_handler_id);
}






static void
changed_closure_invalidate (gpointer  data,
			    GClosure *closure)
{
  ChangedNotifyPair *changed_notify_pair;


  changed_notify_pair = (ChangedNotifyPair *)data;


  changed_notify_pair->changed_object     = NULL;
  changed_notify_pair->changed_handler_id = 0;


  changed_notify_pair_unref (changed_notify_pair);


  if (changed_notify_pair->notify_handler_id != 0)
    {
      g_signal_handler_disconnect
			(changed_notify_pair->notify_object,
			 changed_notify_pair->notify_handler_id);
    }
}



static void
pre_changed_handler (gpointer  data,
		     GClosure *closure)
{
  ChangedNotifyPair *changed_notify_pair;


  changed_notify_pair = (ChangedNotifyPair *)data;

  changed_notify_pair_block_notify_handler (changed_notify_pair);
}

static void
post_changed_handler (gpointer  data,
		      GClosure *closure)
{
  ChangedNotifyPair *changed_notify_pair;


  changed_notify_pair = (ChangedNotifyPair *)data;

  changed_notify_pair_unblock_notify_handler (changed_notify_pair);
}



static void
notify_closure_invalidate (gpointer  data,
			   GClosure *closure)
{
  ChangedNotifyPair *changed_notify_pair;


  changed_notify_pair = (ChangedNotifyPair *)data;


  changed_notify_pair->notify_object     = NULL;
  changed_notify_pair->notify_handler_id = 0;


  changed_notify_pair_unref (changed_notify_pair);


  if (changed_notify_pair->changed_handler_id != 0)
    {
      g_signal_handler_disconnect
			(changed_notify_pair->changed_object,
			 changed_notify_pair->changed_handler_id);
    }
}

static void
pre_notify_handler (gpointer  data,
		    GClosure *closure)
{
  ChangedNotifyPair *changed_notify_pair;


  changed_notify_pair = (ChangedNotifyPair *)data;

  changed_notify_pair_block_changed_handler (changed_notify_pair);
}

static void
post_notify_handler (gpointer  data,
		     GClosure *closure)
{
  ChangedNotifyPair *changed_notify_pair;


  changed_notify_pair = (ChangedNotifyPair *)data;

  changed_notify_pair_unblock_changed_handler (changed_notify_pair);
}





void
changed_notify_pair_changed_connect (ChangedNotifyPair *changed_notify_pair,
				     const gchar       *detailed_signal,
				     GCallback          c_handler,
				     gpointer           data)
{
  GClosure *closure;

  g_return_if_fail (changed_notify_pair != NULL);
  g_return_if_fail (changed_notify_pair->changed_handler_id == 0);



  changed_notify_pair_ref (changed_notify_pair);


  closure = g_cclosure_new (c_handler, data,  NULL);

  g_closure_add_invalidate_notifier
			(closure,
			 changed_notify_pair, changed_closure_invalidate);

  g_closure_add_marshal_guards
			(closure,
			 changed_notify_pair, pre_changed_handler,
			 changed_notify_pair, post_changed_handler);


  changed_notify_pair->changed_handler_id
    = g_signal_connect_closure (changed_notify_pair->changed_object,
				detailed_signal,
				closure,
				FALSE);
}

void
changed_notify_pair_notify_connect (ChangedNotifyPair *changed_notify_pair,
				    const gchar       *detailed_signal,
				    GCallback          c_handler,
				    gpointer           data)
{
  GClosure *closure;

  g_return_if_fail (changed_notify_pair != NULL);
  g_return_if_fail (changed_notify_pair->notify_handler_id == 0);



  changed_notify_pair_ref (changed_notify_pair);


  closure = g_cclosure_new (c_handler, data,  NULL);

  g_closure_add_invalidate_notifier
			(closure,
			 changed_notify_pair, notify_closure_invalidate);

  g_closure_add_marshal_guards
    			(closure,
			 changed_notify_pair, pre_notify_handler,
			 changed_notify_pair, post_notify_handler);


  changed_notify_pair->notify_handler_id
    = g_signal_connect_closure (changed_notify_pair->notify_object,
				detailed_signal,
				closure,
				FALSE);
}
