/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"



static void builtin_module_init (void);

static gpointer create_panel_widget_instance_hierarchy (gpointer data,
							gpointer func_data,
							gpointer invoke_data);
static gpointer create_panel_all_toplevels_hierarchy   (gpointer data,
							gpointer func_data,
							gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_widget_instance_hierarchy (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-widget-instance-hierarchy";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-widget-instance-hierarchy",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  GTK_TYPE_WIDGET,
				  create_panel_widget_instance_hierarchy,
				  NULL);

  g_inspector_register_procedure ("create-panel-all-toplevels-hierarchy",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  GTK_TYPE_WIDGET,
				  create_panel_all_toplevels_hierarchy,
				  NULL);
}



static void
construct_ancestors (GInspectorElementTree *element_tree,
		     GtkWidget             *widget)
{
  GtkWidget *node_widget;
  GtkWidget *parent_node_widget;
  GList     *ancestors;
  GList     *tmp;
  GtkWidget *tmp_widget;

  ancestors = NULL;
  tmp_widget = widget;
  do {
    ancestors = g_list_prepend (ancestors, tmp_widget);
    tmp_widget = gtk_widget_get_parent (tmp_widget);
  } while (tmp_widget != NULL);

  tmp = ancestors;
  parent_node_widget = NULL;
  while (tmp != NULL) {
    tmp_widget = tmp->data;
    tmp = g_list_next (tmp);

    node_widget = g_inspector_element_tree_create_node_label (gtk_widget_get_name (tmp_widget));
    g_inspector_element_tree_node_widget_set_element_gobject (node_widget,
							      G_OBJECT (tmp_widget));

    gtk_tree_container_append_node_widget (GTK_TREE_CONTAINER (element_tree),
					   node_widget,
					   parent_node_widget);

    parent_node_widget = node_widget;
  }

  g_list_free (ancestors);
}

static void
construct_descendants_recurse (GInspectorElementTree *element_tree,
			       GtkWidget             *widget,
			       GtkWidget             *parent)
{
  GtkWidget *node_widget;
  GList     *children;
  GList     *tmp;


  node_widget = g_inspector_element_tree_create_node_label (gtk_widget_get_name (widget));
  g_inspector_element_tree_node_widget_set_element_gobject (node_widget,
							    G_OBJECT (widget));

  gtk_tree_container_append_node_widget (GTK_TREE_CONTAINER (element_tree),
					 node_widget,
					 parent);

  if (GTK_IS_CONTAINER (widget))
    {
      children = gtk_container_get_children (GTK_CONTAINER (widget));

      tmp = children;
      while (tmp != NULL)
	{
	  construct_descendants_recurse (element_tree,
					 GTK_WIDGET (tmp->data),
					 node_widget);
	  tmp = g_list_next (tmp);
	}
      g_list_free (children);
    }
}

static void
construct_descendants (GInspectorElementTree *element_tree,
		       GtkWidget             *widget)
{
  construct_descendants_recurse (element_tree,
				 widget,
				 NULL);
}

static void
construct_all_toplevels (GInspectorElementTree *element_tree)
{
  GList *toplevels;
  GList *tmp;

  toplevels = gtk_window_list_toplevels ();

  tmp = toplevels;
  while (tmp != NULL)
    {
      if (g_inspector_tag_check_widget (GTK_WIDGET (tmp->data)) != TRUE)
	{
	  construct_descendants (element_tree,
				 GTK_WIDGET (tmp->data));
	}
      tmp = g_list_next (tmp);
    }
}


static void
update_ancestors (GInspectorElementTree *element_tree,
		  gpointer               user_data)
{
  GtkWidget *widget;


  widget = GTK_WIDGET (user_data);


  gtk_widget_hide (GTK_WIDGET (element_tree));
  g_inspector_element_tree_clear (element_tree);

  construct_ancestors (element_tree,
		       widget);

  gtk_widget_show_all (GTK_WIDGET (element_tree));
}

static void
update_descendants (GInspectorElementTree *element_tree,
		    gpointer               user_data)
{
  GtkWidget *widget;


  widget = GTK_WIDGET (user_data);


  gtk_widget_hide (GTK_WIDGET (element_tree));
  g_inspector_element_tree_clear (element_tree);

  construct_descendants (element_tree,
			 widget);

  gtk_widget_show_all (GTK_WIDGET (element_tree));
}

static void
update_all_toplevels (GInspectorElementTree *element_tree,
		      gpointer               user_data)
{
  gtk_widget_hide (GTK_WIDGET (element_tree));

  g_inspector_element_tree_clear (element_tree);

  construct_all_toplevels (element_tree);

  gtk_widget_show_all (GTK_WIDGET (element_tree));
}



static GtkWidget *
create_element_tree_ancestors (GtkWidget *widget)
{
  GtkWidget *element_tree;
  
  element_tree = g_inspector_element_tree_new ();

  g_signal_connect (element_tree,
		    "update",
		    G_CALLBACK (update_ancestors),
		    widget);


  return element_tree;
}

static GtkWidget *
create_element_tree_descendants (GtkWidget *widget)
{
  GtkWidget *element_tree;
  
  element_tree = g_inspector_element_tree_new ();

  g_signal_connect (element_tree,
		    "update",
		    G_CALLBACK (update_descendants),
		    widget);


  return element_tree;
}

static GtkWidget *
create_element_tree_all_toplevels (void)
{
  GtkWidget *element_tree;
  
  element_tree = g_inspector_element_tree_new ();

  g_signal_connect (element_tree,
		    "update",
		    G_CALLBACK (update_all_toplevels),
		    NULL);

  g_inspector_element_tree_update (G_INSPECTOR_ELEMENT_TREE (element_tree));


  return element_tree;
}


static gpointer
create_panel_widget_instance_hierarchy (gpointer data,
					gpointer func_data,
					gpointer invoke_data)
{
  GtkWidget *widget;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *scrolled_window_ancestors;
  GtkWidget *scrolled_window_descendants;
  GtkWidget *element_tree_ancestors;
  GtkWidget *element_tree_descendants;


  widget = GTK_WIDGET (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
                          NULL);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Hierarchy");

    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
  }

  {
    scrolled_window_ancestors = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window_ancestors),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_box_pack_start (GTK_BOX (vbox), scrolled_window_ancestors,
			FALSE, FALSE, 0);
  }

  {
    gtk_box_pack_start (GTK_BOX (vbox), gtk_hseparator_new (),
			FALSE, FALSE, 0);
  }

  {
    scrolled_window_descendants = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window_descendants),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_box_pack_start (GTK_BOX (vbox), scrolled_window_descendants,
			TRUE, TRUE, 0);
  }

  {
    element_tree_ancestors = create_element_tree_ancestors (widget);

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window_ancestors),
					   element_tree_ancestors);

#if 1
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window_ancestors)->child),
				  GTK_SHADOW_NONE);
#endif
  }

  {
    element_tree_descendants = create_element_tree_descendants (widget);

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window_descendants),
					   element_tree_descendants);

#if 1
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window_descendants)->child),
				  GTK_SHADOW_NONE);
#endif
  }

  {
    g_inspector_panel_attach_element_tree (G_INSPECTOR_PANEL (panel),
					   G_INSPECTOR_ELEMENT_TREE (element_tree_ancestors));

    g_inspector_panel_attach_element_tree (G_INSPECTOR_PANEL (panel),
					   G_INSPECTOR_ELEMENT_TREE (element_tree_descendants));
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }




  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}

static gpointer
create_panel_all_toplevels_hierarchy (gpointer data,
				      gpointer func_data,
				      gpointer invoke_data)
{
  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_tree;


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
                          NULL);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Widget Tree");

    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    element_tree = create_element_tree_all_toplevels ();

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window),
					   element_tree);

#if 1
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window)->child),
				  GTK_SHADOW_NONE);
#endif
  }

  {
    g_inspector_panel_attach_element_tree (G_INSPECTOR_PANEL (panel),
					   G_INSPECTOR_ELEMENT_TREE (element_tree));
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }




  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}
