
#include "config.h"
#include <math.h>
#include <stdio.h>

#include "gdis.h"

#define T_STEP 0.001

gfloat *s_data;

/************************************/
/* initialize the trig lookup table */
/************************************/
void init_trig()
{
gint i;
gfloat a,s;

/* alloc */
s_data = (gfloat *) g_malloc((1+PI/T_STEP) * sizeof(float));

#if DEBUG_TRIG
printf("Initializing table: ");
#endif
i=0;
for (a=0.0 ; a<=PI ; a+= T_STEP)
  {
  s = sin(a);
  *(s_data+i) = s;
  i++;
  }
#if DEBUG_TRIG
printf("%d points stored.\n",i);
#endif
}

/********************/
/* SINE replacement */
/********************/
gfloat tbl_sin(gfloat angle)
{
gint quad, idx;
gfloat test,s,a,s1,s2,rem;

/* range check */
while (angle < 0)
  angle += 2.0*PI;
while (angle > 2.0*PI)
  angle -= 2.0*PI;

/* determine quadrant */
test = angle;
quad = 0;
while (test > PI/2.0)
  {
  test -= PI/2.0;
  quad++;
  }

/* setup angle and sign accordingly */
switch (quad)
  {
  case 0:
    a = test;
    s = 1.0;
    break;
  case 1:
    a = test + PI/2.0;
    s = 1.0;
    break;
  case 2:
    a = test;
    s = -1.0;
    break;
  case 3:
    a = test + PI/2.0;
    s = -1.0;
    break;
  default:
    printf("Error in tbl_sin(): bad quadrant!\n");
    return(0.0);
  }

/* retreive */
idx = (gint) (0.5 + a / T_STEP);
rem = a / T_STEP - (gint) (a / T_STEP);
/* get the two closest values */
s1 = *(s_data+idx) * s;
s2 = *(s_data+idx-1) * s;
/* weighted average */
s = (rem*s2 + (1.0-rem)*s1);

return(s);
}

/**********************/
/* COSINE replacement */
/**********************/
gfloat tbl_cos(gfloat angle)
{
gfloat s;

s = tbl_sin(angle - PI/2.0);
return(s);
}

