/* 
   Copyright (C) 1999 Kyle R. Burton, All Rights Reserved
   mortis@voicenet.com
   http://www.bgw.org
   http://www.voicenet.com/~mortis

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
Heavily modified by Sean Fleming for the GDIS program
*/

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
#include <assert.h>
#include <errno.h>
#include <gtk/gtk.h>

#include "gperiodic.h"
#include "gdis.h"

extern struct sysenv_pak sysenv;
extern struct elem_pak elements[];

extern GtkWidget *window;

/*************/
/* gtk hooks */
/*************/
void dialog_destroy(GtkWidget *w)
{
gtk_grab_remove(GTK_WIDGET(w));
}

void change_cova(GtkWidget *w, gpointer *spin)
{
gint code;
gfloat r;
GtkWidget *parent;

/* retrieve title from top level widget, which */
/* should be the element to apply the change to */
parent = gtk_widget_get_toplevel(GTK_WIDGET(spin));
code = elem_type(GTK_WINDOW(parent)->title);
r = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(spin));

elements[code].cova = r;
}

void change_vdw(GtkWidget *w, gpointer *spin)
{
gint code;
gfloat r;
GtkWidget *parent;

parent = gtk_widget_get_toplevel(GTK_WIDGET(spin));
code = elem_type(GTK_WINDOW(parent)->title);
r = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(spin));

elements[code].vdw = r;
}

/***********************************/
/* on the fly table colour refresh */
/***********************************/
void refresh_table()
{
gint i;
GtkStyle *style;

for(i=0 ; i<sizeof(table) ; i++) 
  {
/* stop if no more element data (NB: gperiodic/gdis index mismatch) */
  if(i >= sysenv.num_elements-1) 
    break;
/* jump the gaps */
  if (GTK_IS_WIDGET(table[i].button)) 
    {
    style = gtk_style_copy(gtk_widget_get_style(window));
    style->bg[GTK_STATE_NORMAL].red = elements[i+1].colour[0];
    style->bg[GTK_STATE_NORMAL].green = elements[i+1].colour[1];
    style->bg[GTK_STATE_NORMAL].blue = elements[i+1].colour[2];
    gtk_widget_set_style(table[i].button, style);
    }
  }
}

/*****************************************/
/* make a change to an elements's colour */ 
/*****************************************/
void elem_colour_change(GtkWidget *w, gpointer *obj)
{
gdouble colour[3];
gpointer *widget;
GtkStyle *style;
struct model_pak *data;
struct elem_pak *elem_data;

/* checks */
g_return_if_fail(obj != NULL);

/* get colour from csd */
gtk_color_selection_get_color((GtkColorSelection *) obj, colour);
VEC3MUL(colour, 65535);

/* retreive the element & update */
elem_data = gtk_object_get_data(GTK_OBJECT(obj), "ptr");
ARR3SET(elem_data->colour, colour);

/* get style copy & update single element colour sample */
widget = gtk_object_get_data(GTK_OBJECT(obj), "wid");
/* check, since the user might have since deleted the single element dialog */
if (GTK_IS_WIDGET(widget))
  {
  style = gtk_style_copy(gtk_widget_get_style(w));
  style->bg[0].red   = colour[0];
  style->bg[0].green = colour[1]; 
  style->bg[0].blue  = colour[2]; 
  gtk_widget_set_style(GTK_WIDGET(widget), style);
  }
/* update entire table */
refresh_table();

/* refresh atom colours */
data = model_ptr(sysenv.active, RECALL);
if (data)
  {
  init_objs(REFRESH_COLOUR, data);
/* redo region lighting (if any) */
  if (data->mode == REGION_LITE)
    init_objs(REFRESH_LITE, data);
  }

/* redraw */
redraw_canvas(SINGLE);
}

/***************************/
/* Single element dialogue */
/***************************/
void display_element_dialog(GtkWidget *w, gint i)
{
struct table_entry *entry;
GtkWidget *dialog, *vbox, *hbox;
GtkWidget *label, *button, *cr_spin, *vr_spin;
GtkStyle *style, *newstyle;
GtkAdjustment *adj;

entry = (struct table_entry *) &table[i];

/* display this in a dialog box... */
dialog = gtk_dialog_new();
gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
                   GTK_SIGNAL_FUNC(dialog_destroy), dialog);
gtk_window_set_title(GTK_WINDOW(dialog), elements[i+1].symbol);
gtk_container_set_border_width(GTK_CONTAINER(dialog), 5 );

/* two column element data display */
hbox = gtk_hbox_new(FALSE,0);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, TRUE, FALSE, 0);

/* left vbox - titles */
vbox = gtk_vbox_new(TRUE,0);
gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

/* TODO - put in a for loop? */
label = gtk_label_new("Name:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Symbol:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Number:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Weight:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Ionic/Covalent radius:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("VdW radius:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Colour:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);

/* right vbox - data */
vbox = gtk_vbox_new(TRUE,0);
gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

label = gtk_label_new (elements[i+1].name);
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new (elements[i+1].symbol);
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new (g_strdup_printf("%d", i+1));
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new (g_strdup_printf("%8.4f", elements[i+1].weight));
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);

/* cova radius */
adj = (GtkAdjustment *) gtk_adjustment_new
                        (elements[i+1].cova, 0.1, 3.0, 0.1, 0.1, 0);
/* data to pass to callback */
cr_spin = gtk_spin_button_new (adj, 0.1, 2);
gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(cr_spin), FALSE);
gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(cr_spin), GTK_SHADOW_OUT);
gtk_signal_connect(GTK_OBJECT (adj), "value_changed",
                    GTK_SIGNAL_FUNC (change_cova), (gpointer) cr_spin);
gtk_box_pack_start(GTK_BOX(vbox), cr_spin, TRUE, TRUE, 0);

/* vdW radius */
adj = (GtkAdjustment *) gtk_adjustment_new
                        (elements[i+1].vdw, 0.1, 4.0, 0.1, 0.1, 0);
/* data to pass to callback */
vr_spin = gtk_spin_button_new(adj, 0.1, 2);
gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(vr_spin), FALSE);
gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(vr_spin), GTK_SHADOW_OUT);
gtk_signal_connect(GTK_OBJECT (adj), "value_changed",
                    GTK_SIGNAL_FUNC (change_vdw), (gpointer) vr_spin);
gtk_box_pack_start(GTK_BOX(vbox), vr_spin, TRUE, TRUE, 0);

/* button with element's colour, click to edit */
gtk_widget_realize(dialog);
style = gtk_widget_get_style(dialog);
newstyle = gtk_style_copy(style);
newstyle->bg[0].red   = elements[i+1].colour[0];
newstyle->bg[0].green = elements[i+1].colour[1];
newstyle->bg[0].blue  = elements[i+1].colour[2];

/* update!!! */
button = gtk_button_new_with_label("    edit    ");
gtk_widget_set_style(button, newstyle);
gtk_signal_connect(GTK_OBJECT (button), "clicked",
                   GTK_SIGNAL_FUNC(colsel_dialog), (gpointer) button);
gtk_object_set_data(GTK_OBJECT(button), "id", (gpointer) ELEMENT_COLOUR);
gtk_object_set_data(GTK_OBJECT(button), "ptr", (gpointer) &elements[i+1]);
gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, TRUE, 0);

hbox = gtk_hbox_new(FALSE,0);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), hbox, FALSE, TRUE, 0);
button = gtk_button_new_with_label("  Close  ");
gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);
gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                          GTK_SIGNAL_FUNC(gtk_widget_destroy),
                          GTK_OBJECT(dialog));

gtk_widget_show_all(dialog);
}

/******************************/
/* Construct a periodic table */
/******************************/
void gperiodic_win(void)
{
gint i, id;
gchar *buff=NULL;
GtkWidget *label, *vbox, *periodic_table, *hbox, *button;
GdkColor tooltip_color_bg, tooltip_color_fg;
GtkStyle *style;
struct dialog_pak *gperiodic;

/* retrieve a suitable dialog */
if ((id = request_dialog(-1, GPERIODIC)) < 0)
  return;
gperiodic = &sysenv.dialog[id];

/* SGI - make the new visual active (and push the old) */
gtk_widget_push_colormap(sysenv.colourmap);
gtk_widget_push_visual(sysenv.visual);

/* create the main window */
gperiodic->win = gtk_dialog_new();
gtk_window_set_title(GTK_WINDOW(gperiodic->win),"GPeriodic");
gtk_signal_connect(GTK_OBJECT(gperiodic->win), "destroy",
                   GTK_SIGNAL_FUNC(event_close_dialog), (gpointer) id);

/* background colour for GPeriodic - LEMON */
style = gtk_widget_get_style(gperiodic->win);
style->bg[0].red = 64890;
style->bg[0].green = 65535;
style->bg[0].blue = 53739;
gtk_widget_set_style(gperiodic->win, style);

/* use a vbox for the menubar and the table of elements... */
vbox = gtk_vbox_new(FALSE,0);
gtk_container_border_width(GTK_CONTAINER(vbox),2);
gtk_container_add (GTK_CONTAINER(GTK_BOX(GTK_DIALOG(gperiodic->win)->vbox)),vbox);

/* nice heading */
label = gtk_label_new("Periodic table of the Elements");
gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0 );

/* create the table widget to hold the periodic table */
periodic_table = gtk_table_new(1,1,TRUE);
gtk_box_pack_start( GTK_BOX(vbox), periodic_table, FALSE, FALSE, 0 );


/* now for each element in the table of elements, create a display */
/* item for it, and add it to the table... */
for(i=0 ; i<sizeof(table) ; i++ ) 
  {
/* stop if no more element data (NB: gperiodic/gdis index mismatch) */
  if(i >= sysenv.num_elements-1) 
    break;
/* create the button */
  table[i].button = gtk_button_new_with_label(elements[i+1].symbol);

/******************************************************************************/
  {

  GtkStyle *button_style = gtk_widget_get_style(gperiodic->win);

  table[i].style = gtk_style_copy(button_style);

/* set for 0, 1, and 2 */
/* unlit */
  table[i].style->bg[0].red   = elements[i+1].colour[0];
  table[i].style->bg[0].green = elements[i+1].colour[1];
  table[i].style->bg[0].blue  = elements[i+1].colour[2];
/* lit */
/*
  table[i].style->bg[1].red   = table[i].color.red;
  table[i].style->bg[1].green = table[i].color.green;
  table[i].style->bg[1].blue  = table[i].color.blue;

  table[i].style->bg[2].red   = table[i].color.red;
  table[i].style->bg[2].green = table[i].color.green;
  table[i].style->bg[2].blue  = table[i].color.blue;
*/

  gtk_widget_set_style(table[i].button, table[i].style );
  }
/******************************************************************************/

/* connect the destroy method to it */
  gtk_signal_connect(GTK_OBJECT(table[i].button), "clicked",
                     GTK_SIGNAL_FUNC(display_element_dialog), (gpointer) i);

/* set up a string for the tooltips */
  buff = g_strdup_printf("%s  n:%d", elements[i+1].symbol, i+1);

/* create a new tooltips object... */
  table[i].tooltip = gtk_tooltips_new();
  gtk_tooltips_set_delay(table[i].tooltip,100);
  gtk_tooltips_set_tip(table[i].tooltip,table[i].button,buff,NULL);
  gtk_tooltips_set_colors(table[i].tooltip,&tooltip_color_bg,&tooltip_color_fg);

/* attach the button to the table */
  gtk_table_attach(GTK_TABLE(periodic_table), table[i].button,
                   table[i].x - 1, table[i].x,
                   table[i].y - 1, table[i].y,
                   GTK_FILL, GTK_FILL,              /* opts */
                   2, 2);                           /* ypad */
  }

/* terminating buttons */
hbox = gtk_hbox_new(FALSE,0);
gtk_box_pack_start (GTK_BOX(GTK_DIALOG(gperiodic->win)->action_area),
                    hbox, TRUE, FALSE, 0);

button = gtk_button_new_with_label("    Close    ");
gtk_widget_set_style(button, style);
gtk_box_pack_start (GTK_BOX(hbox), button, FALSE, FALSE, 0);
gtk_signal_connect(GTK_OBJECT(button), "clicked",
                   GTK_SIGNAL_FUNC(event_close_dialog), (gpointer) id);

gtk_widget_show_all(gperiodic->win);

/* SGI - restore the old visual */
gtk_widget_pop_visual();
gtk_widget_pop_colormap();

free(buff);
}
