/*
Copyright (C) 2000 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include "config.h"
#include "setoper.h" 
  /* set operation library header (March 16, 1995 version or later) */
#include "cdddef.h"
#include "cdd.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <string.h>

#include "gdis.h"

/* TODO - get rid of all n_input's - it's always 4 ie len,x,y,z*/
#define NDIM 4

/* CDD main call */
gint DDEnumerate(rowrange, colrange, rowrange, colrange, Amatrix, struct model_pak *);

long mprev;
double *beta;
long mlast;

/************************/
/* transfer vertex data */
/************************/
#define DEBUG_SAVE_VERTEX 0
void save_vertex(struct model_pak *data)
{
gint j;
RayRecord *RR;

/* setup for placing in GDIS struct */
data->num_vertices = VertexCount;
if (data->num_vertices < 4)
  {
  printf("Insufficient planes to define a closed polyhedron.\n");
/* force bad */
  data->num_vertices=0;
  return;
  }
data->vertices = (struct vertex_pak *) 
                  g_malloc(data->num_vertices * sizeof(struct vertex_pak));

#if DEBUG_SAVE_VERTEX
printf("Found %d vertices.\n",data->num_vertices);
printf("Vertex list:\n");
#endif

RR = FirstRay;
j=0;
while (RR != NULL) 
  {
  if (RR->feasible) 
    {
#if DEBUG_SAVE_VERTEX
printf("[%d]  ",j);
printf("%5.2f %5.2f %5.2f\n",RR->Ray[0]/fabs(RR->Ray[0])
                            ,RR->Ray[1]/fabs(RR->Ray[0])
                            ,RR->Ray[2]/fabs(RR->Ray[0]));
#endif

if (j>=data->num_vertices)
  printf("HELP!\n");
    (data->vertices+j)->x = RR->Ray[1]/fabs(RR->Ray[0]);
    (data->vertices+j)->y = RR->Ray[2]/fabs(RR->Ray[0]);
    (data->vertices+j)->z = RR->Ray[3]/fabs(RR->Ray[0]);
    j++;
    }
  RR = RR->Next;
  }
}

/***************************/
/* transfer adjacency data */
/***************************/
#define DEBUG_SAVE_ADJ 0
void save_adj(struct model_pak *data, Amatrix A)
{
gint i, j, id, m_size, n_size;
RayRecord *RayPtr1, *RayPtr2;
long pos1, pos2, degree;
boolean adj;
node *headnode, *tailnode, *newnode, *prevnode;

headnode=NULL; tailnode=NULL;

m_size = data->num_planes + 1;
n_size = NDIM;

#if DEBUG_SAVE_ADJ
printf("Adjacency list:\n");
#endif

if (RayCount==0)
  return;

LastRay->Next=NULL;
for (RayPtr1=FirstRay, pos1=1;RayPtr1 != NULL; RayPtr1 = RayPtr1->Next, pos1++)
  {
  for (RayPtr2=FirstRay, pos2=1,degree=0; RayPtr2 != NULL; RayPtr2 = RayPtr2->Next, pos2++)
    {
    if (RayPtr1!=RayPtr2)
      {
        CheckAdjacency2(m_size, n_size, A, &RayPtr1, &RayPtr2, &adj);
        if (adj) 
          {
          degree++;
          if (degree==1)
            {
            newnode=(node *)g_malloc(sizeof *newnode);
            newnode->key=pos2;
            newnode->next=NULL;
            headnode=newnode;
            tailnode=newnode;
            }
          else
            {
            newnode=(node *)g_malloc(sizeof *newnode);
            newnode->key=pos2;
            newnode->next=NULL;
            tailnode->next=newnode;
            tailnode=newnode;
            }
          }
        }
      }
/* stupid pascal numbering */
    i = (gint) pos1-1;
    j = (gint) degree;
/*
if (j < 3)
  printf("Warning: bad vertex.\n");
*/
#if DEBUG_SAVE_ADJ
printf(" Vertex %d  has %d adj :", i, j);
#endif
/* allocate for adjacency */
    (data->vertices+i)->num_adj = j;
    (data->vertices+i)->adj = (gint *) g_malloc(j*sizeof(gint));
    j=0;
    for (newnode=headnode; newnode!=NULL; newnode=newnode->next, free(prevnode))
      {
      prevnode=newnode;
/* stupid pascal numbering */
      id = (gint) newnode->key - 1;
      *((data->vertices+i)->adj+j) =  id;
#if DEBUG_SAVE_ADJ
printf(" %d", id);
#endif
      j++;
      }
#if DEBUG_SAVE_ADJ
printf("\n");
#endif
  }
}

/******************************/
/* compute visible facet data */
/******************************/
#define DEBUG_SAVE_FACET 0
void save_facet(struct model_pak *data)
{
gint i, m, id, p, vertex;
gint *planes;
long elem, zcar;
rowset cset;
RayRecord *RR;
GSList *plist;
struct plane_pak *plane;

m = data->num_planes+1;

/* FIXME -  are 3 these being overrun somewhere? */
/*          doesn't seem so, but adding a 10 * factor */
/*          helps a bit (but doesn't completely fix) */

/* number of facets <= number of input planes */
planes = (gint *) g_malloc(data->num_planes*sizeof(gint));
for (i=0 ; i<data->num_planes ; i++)
  *(planes+i) = 0;

/* pass1 - get sizes for alloc */
#if DEBUG_SAVE_FACET
printf("Planes:\n");
#endif
RR = FirstRay;
i=0;
while (RR != NULL) 
  {
  if (RR->feasible) 
    {
    set_initialize(&cset,m);
    zcar = set_card(RR->ZeroSet);
    if (m - zcar >= zcar) 
      {
#if DEBUG_SAVE_FACET
printf("Vetex %d at junction of %1ld planes: ",i,zcar);
#endif
      for (elem=1 ; elem<=RR->ZeroSet[0] ; elem++)
        if (set_member(elem,RR->ZeroSet))
          {
/* plane number */
          id = (gint) elem-1;
          if (id >= data->num_planes)
            printf("HELP!\n");
#if DEBUG_SAVE_FACET
printf("%d ",id);
#endif
/* facet number id has another vertex */
/* NB: stupid pascal numbering */
          (*(planes+id))++;
          }
      i++;
#if DEBUG_SAVE_FACET
printf("\n");
#endif
      }
    else 
      {
      printf("badly truncated code.\n");
      }
    set_free(cset);
    }
  RR = RR->Next;
  }

/* allocate & init for each facet's vertex listing */
i=0;
data->num_facets = 0;
plist = data->planes;
while (plist != NULL)
  {
  plane = (struct plane_pak *) plist->data;
  p = *(planes+i);
  if (p)
    {
#if DEBUG_SAVE_FACET
printf("plane %d has %d vertices.\n",i,p);
#endif
    plane->points = (gint *) g_malloc(p*sizeof(gint));
    plane->num_points = 0;
    plane->lim_points = p;
/* TODO - this can now be pruned a bit */
/* get plane label (miller indices) */
    ARR3SET(plane->index, plane->m);
/* NEW cartesian normal is now calculated before */
    ARR3SET(plane->norm, plane->x);
/* planes->x is -ve inequality, remember! */
    VEC3MUL(plane->norm, -1.0);
/* this is a present facet */
    plane->present = TRUE;
    data->num_facets++;
    }
  else
    plane->present = FALSE;
/* next */
  plist = g_slist_next(plist);
  i++;
  }

#if DEBUG_SAVE_FACET
printf("Number of visible facets: %d\n",data->num_facets);
#endif

/* pass2 - construct vertex list for each facet */
RR = FirstRay;
vertex=0;
while (RR != NULL) 
  {
  if (RR->feasible) 
    {
    set_initialize(&cset,m);
    zcar = set_card(RR->ZeroSet);
    if (m - zcar >= zcar) 
      {
      for (elem=1 ; elem<=RR->ZeroSet[0] ; elem++)
        {
        if (set_member(elem,RR->ZeroSet))
          {
/* facet number elem 'contains' current vertex */
/* NB: stupid pascal numbering */
          i = (gint) elem - 1;
          plane = (struct plane_pak *) g_slist_nth_data(data->planes, i);

          p = plane->num_points;
          *(plane->points+p) = vertex;
          plane->num_points++;
          }
        }
      vertex++;
      }
    }
  RR = RR->Next;
  }

/* output summary */
#if DEBUG_SAVE_FACET
printf("-----------------------------\n");
for (i=0 ; i<data->num_planes ; i++)
  {
  plane = (struct plane_pak *) g_slist_nth_data(data->planes, i);
  printf("facet %d has %d vertices.\n",i,plane->num_points);
  }
#endif

/* done */
g_free(planes);
}

/*****************************************************/
/* Main morphology call for vertex/facet enumeration */
/*****************************************************/
#define DEBUG_EXEC_CDD 0
gint exec_cdd(struct model_pak *data)
{
gint i,j, status, num_zero;
gfloat max;
rowrange m_input, m_size;
colrange n_input;
Amatrix AA;
GSList *plist;
struct plane_pak *plane;

#if DEBUG_EXEC_CDD
printf("exec_cdd() start\n");
#endif

/* static initialization */
mprev=0;
beta = NULL;
mlast=0;

/* setup run flags */
HyperplaneOrder = LexMin;
AdjacencyTest = Combinatorial;
NondegAssumed = FALSE;
RecomputeRowOrder=TRUE;
PreOrderedRun=FALSE;
InitBasisAtBottom = FALSE;
Error=None;
CompStatus=InProgress;
m_input = data->num_planes;
n_input = NDIM;                   /* ineq -> len + h k l */
/* can be Real or Integer, makes no diff (even if input is float, strange) */
Number = Real;
/*
Number = Integer;
*/
RestrictedEnumeration = FALSE;
RelaxedEnumeration = FALSE;

/* feed planes into matrix */
max=0.0;
i=num_zero=0;
plist = data->planes;
while (plist != NULL)
  {
  plane = (struct plane_pak *) plist->data;

  AA[i]= (double *) calloc(n_input, sizeof(double));

/* TODO - use space group to fill out extra planes if needed */
/* scaling greatly helps remove precision errors (eg BFDH baso4.gin) */
  switch(data->type)
    {
    case LENGTH:
      AA[i][0] = (double) fabs(plane->len);
      break;
    case DHKL:
      AA[i][0] = (double) 1.0/fabs(plane->dhkl);
      break;
    case EATT:
      AA[i][0] = (double) fabs(plane->Eatt);
      break;
    case ESURF:
      AA[i][0] = (double) fabs(plane->Esurf);
      break;
    default:
      printf("Bad morph type.\n");
      exit;
    }
/* input normalized miller indices */
  for (j=1 ; j<n_input ; j++) 
    AA[i][j] = (double) plane->x[j-1];
/* prevent 0 length faces from wiping out the hull */
  if (AA[i][0] < FRACTION_TOLERANCE)
    {
    for (j=1 ; j<n_input ; j++) 
      AA[i][j] = 0.0;
    num_zero++;
    }
/* get maximum - for later scaling */
  if (AA[i][0] > max)
    max = AA[i][0];

/* next */
  i++;
  plist = g_slist_next(plist);
  }

if (num_zero == i)
  {
#if DEBUG_EXEC_CDD
printf("No non-zero input planes found.\n");
#endif
  return(1);
  }
else
  {
/* there seem to be a lot of precision errors related to scaling */
/* a value of 200 seems to work well with most existing gmf models, */
/* with the exception of caox.gin - BFDH. But, if the scale is changed */
/* to 100 or 500 then some other models will not be displayed */
/* correctly - it's a mystery. */
/* at 700 - caox BFDH works, but hex.gmf doesn't */
/* Hey, 10 works even better! */
#define MORPH_SCALE 10.0
  if (max > FRACTION_TOLERANCE)
    for (j=0 ; j<i ; j++)
      AA[j][0] *= MORPH_SCALE/max;
  }

/* non homogeneous - add row */
m_size = m_input + 1;
AA[m_size-1] = (double *) calloc(n_input, sizeof(double));
/* artificial row for x_1 >= 0*/
AA[m_size-1][0] = 1.0;
for (j=1 ; j<n_input ; j++) 
  AA[m_size-1][j] = 0.0;

/* more init */
EqualityIndex = (long *) calloc(m_size+1, sizeof(EqualityIndex));
SetInequalitySets(m_size, EqualityIndex);

/* DEBUG - main input matrix */
#if DEBUG_EXEC_CDD
printf("input inequalities:\n");
for (i=0 ; i<m_size ; i++)
  {
  for (j=0 ; j<n_input ; j++)
    {
    printf("%10.2f ",AA[i][j]);
    }
  printf("\n");
  }
printf("\n\n");
#endif

/* vertex/facets enumeration - and model_pak storage */
status = DDEnumerate(m_input, n_input, m_size, n_input, AA, data);

if (beta)
  g_free(beta);

return(status);
}

