/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "detect.h"
#include "utils.h"


extern struct printer_info *printer_detect(struct bus_lst *bus){
  char i = '0';
  char *buff;
  char *line;
  size_t len = 0;
  struct parallel_info *parallel = (struct parallel_info *)NULL;
  struct usb_info *usb = (struct usb_info *)NULL;
  struct printer_info *result = (struct printer_info *)NULL;
  static struct printer_info *first = (struct printer_info *)NULL;

  FILE *f;
  

  if(first){
    return first;
  }/*endif*/
  
  if(debug)
    fprintf(stdout, "\nProbing printer...\n");


  /********************************************************************/
  /********************** USB PRINTER *********************************/
  /********************************************************************/
 if(debug)
   fprintf(stdout, "\tProbing USB printer..\n");
  
  for(usb = bus->usb; usb; usb = usb->next){
    if(usb->type == PRINTER){
      if(!first){
        first = result = (struct printer_info *)
                                 my_malloc(sizeof(struct printer_info));
      }else{
        result->next = (struct printer_info *)
                                 my_malloc(sizeof(struct printer_info));
        result = result->next;
      }/*endif*/
      result->next = (struct printer_info *)NULL;
      result->vendor = usb->vendor;
      result->model = usb->model;
      result->device = s_not_available;
      result->module = usb->modulename;
      result->long_id = usb->id;
      result->bus = USB;
      if(debug){
        fprintf(stdout, "\t\tFound %s", result->model);
      }/*endif*/
    }/*endif*/
  }/*next usb*/
  
  
  /********************************************************************/
  /******************* PARALLEL PRINTER DETECTION *********************/
  /********************************************************************/
  if(debug){
    fprintf(stdout, "\tProbing parallel printer...\n");
  }
  for(parallel = bus->parallel; parallel; parallel=parallel->next){
    buff = (char *)my_malloc(strlen("/proc/parport/autoprobe") + 
                                                         sizeof(i) + 1);
    sscanf(parallel->device, "/dev/lp%c", &i);
    sprintf(buff, "/proc/parport/%c/autoprobe", i);
    if(!(f = fopen(buff, "r"))){
      fprintf(stderr, FOPEN_READ_ERROR, buff);
    }else{
      if(!find_word("CLASS:PRINTER", buff)){
        /* let's look if we have an `old' device: First probable    */
        /* devices were all printer => they had no CLASS-line ...   */
        if(find_word("CLASS:", buff) || find_word("MODEL:Unknown", buff)){
          continue;
        }/*endif*/
      }/*endif*/
      if(result != (struct printer_info *)NULL){
        result->next = (struct printer_info *)
                                 my_malloc(sizeof(struct printer_info));
        result = result->next;
      }else{
        first = result = (struct printer_info *)
                                 my_malloc(sizeof(struct printer_info));
      }/*endif*/
      result->next = (struct printer_info *)NULL;
      
      result->vendor = s_unknown;
      result->model = s_unknown;
      result->device = parallel->device;
      result->module = s_ignore;
      result->bus = PARALLEL;
      
      while(getline(&line, &len, f) >= 0){
        if(strstr(line, "MANUFACTURER:")){
          result->vendor = (char *)my_malloc(32);
          sscanf(line, "MANUFACTURER:%32[^;]\n", result->vendor);
        }else if(strstr(line, "MODEL:")){
          result->model = (char *)my_malloc(256);
          sscanf(line, "MODEL:%256[^;]\n", result->model);
        }/*endif*/
      }/*endwhile*/
      len = 0;
      free(line);
      fclose(f);
      if(debug){
        fprintf(stdout, "\t\tFound %s", result->model);
      }/*endif*/
    }/*endif*/
  }/*next parallel*/
 return first ;
}/*endfunc printer_detect*/
