/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>
#include <stdio.h>

#include "detect.h"
#include "utils.h"

#define PARALLEL_DEVICES "/dev/lp"

#define PARALLEL_DOS_EQUIVALENT "LPT"

#define NUMBER_OF_VALID_PARALLEL_PORTS 3


struct parallel_info *parallel_detect(){
  char *testing_port = (char *)NULL;
  int i;

  FILE *fd;
  struct parallel_info *result = (struct parallel_info *)NULL;
  static struct parallel_info *first = (struct parallel_info *)NULL;


  if(debug)
    fprintf(stdout, "\nProbing parallel ports...\n");

  /********************************************************************/
  /********************* PARALLEL PORT DETECTION **********************/
  /********************************************************************/

  /* Need to try to open /dev/lp<i> ports */
  for (i=0; i < NUMBER_OF_VALID_PARALLEL_PORTS; i++){
    testing_port = (char *)
                 my_malloc((strlen(PARALLEL_DEVICES) + 2)*sizeof(char));
    sprintf(testing_port, "%s%d", PARALLEL_DEVICES, i);

    /* if we can open the device */
    fd = fopen(testing_port, "rw");

    if(fd){
      fclose(fd);
      if(debug)
	fprintf(stdout, "\t\tFound [%s]\n", testing_port);
      if(!first){
        first = result = (struct parallel_info *)
                                my_malloc(sizeof(struct parallel_info));
      }else{
        result->next = (struct parallel_info *)
                                my_malloc(sizeof(struct parallel_info));
        result = result->next;
      }/*endif*/
      result->next = (struct parallel_info *)NULL;

      result->device = testing_port;
      result->dos_equivalent = (char *)
          my_malloc((strlen(PARALLEL_DOS_EQUIVALENT) + 2)*sizeof(char));
      sprintf(result->dos_equivalent, "%s%d", PARALLEL_DOS_EQUIVALENT, i);
    }else{
      free(testing_port);
    }/*endif*/
  }/*next i*/

  return first;
}/*endfunc parallel_detect*/
