#!/usr/local/bin/perl -sw
#
# $Id: Makefile.PL 
#
# You may distribute under the terms of either the GNU General Public
# License or the Artistic License, as specified in the Perl README file.
#

BEGIN { require 5.004 }
use Config;
use ExtUtils::MakeMaker 5.16, qw(&WriteMakefile $Verbose);
use File::Basename;
use Getopt::Long;

use DBI 0.93;		# must be installed first
use DBI::DBD;
use strict;

my %opts = 
(
    NAME	=> 'DBD::dbftp',
    VERSION_FROM => 'dbftp.pm',
    clean	=> { FILES=> 'dbftp.xsi' },
    dist	=> {
	#DIST_DEFAULT=> 'clean distcheck disttest ci tardist',
	DIST_DEFAULT=> 'clean distcheck ci tardist',
	PREOP    => '$(MAKE) -f Makefile.old distdir',
	COMPRESS => 'gzip -v9', SUFFIX => 'gz'
    },
    OBJECT	=> '$(O_FILES)',
);
if ($ExtUtils::MakeMaker::VERSION >= 5.43) {
    $opts{AUTHOR} = 'Cristian Giussani ( http://www.isc.org/dbi-lists.html )';
    $opts{ABSTRACT} = 'dbtcp driver for the DBI module.';
    $opts{PREREQ_PM} = { DBI => 0 };
    $opts{CAPI} = 'TRUE' if $Config{archname} =~ /-object\b/i;
}

$::opt_g = 0;
$::opt_o = '';
GetOptions(qw(g! o=s)) or die "Invalid arguments";

$opts{OPTIMIZE} = '-g -O0' if $::opt_g;


print "\nConfiguring DBD::dbftp ...\n
>>>\tRemember to actually *READ* the README file!
   \tAnd re-read it if you have any problems.\n
";

my $dbi_dir      = dbd_dbi_dir();
my $dbi_arch_dir = dbd_dbi_arch_dir();

print "\n";

$opts{INC}  = "-I.. -I../utils -I. -I$dbi_arch_dir";
$opts{LIBS} = "-L../libs -ldbftp";

WriteMakefile(%opts);

local($^W)=0;
print qq{
The DBD::dbftp tests will use these values for the database connection:
    DBI_DSN=$ENV{DBI_DSN}		e.g. my_win_dsn
    DBI_HOST=$ENV{DBI_HOST}
    DBI_TABLE=$ENV{DBI_TABLE}
    DBI_USER=$ENV{DBI_USER}             login ( if needed )
    DBI_PWD=$ENV{DBI_PWD}               password ( if needed )
};
print "Warning: not all required environment variables are set.\n"
	unless ($ENV{DBI_DSN} && $ENV{DBI_HOST} && $ENV{DBI_TABLE} );
print "\n";


sub MY::postamble {
    return dbd_postamble(@_);
}

__END__
