/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gMenus.h"
#include "ePlayer.h"
#include "rScreen.h"
#include "nConfig.h"
#include "rConsole.h"
#include "tToDo.h"
#include "rGL.h"
#include "eTimer.h"
#include "eFloor.h"
#include "rRender.h"
#include "rModel.h"
#include "gGame.h"

static REAL subby_SpeedGaugeSize=.175, subby_SpeedGaugeLocX=0.0, subby_SpeedGaugeLocY=-0.9;
static tConfItem<REAL> sgs("SPEED_GAUGE_SIZE",subby_SpeedGaugeSize);
static tConfItem<REAL> sgx("SPEED_GAUGE_LOCX",subby_SpeedGaugeLocX);
static tConfItem<REAL> sgy("SPEED_GAUGE_LOCY",subby_SpeedGaugeLocY);

static REAL subby_BrakeGaugeSize=.175, subby_BrakeGaugeLocX=0.48, subby_BrakeGaugeLocY=-0.9;
static tConfItem<REAL> bgs("BRAKE_GAUGE_SIZE",subby_BrakeGaugeSize);
static tConfItem<REAL> bgx("BRAKE_GAUGE_LOCX",subby_BrakeGaugeLocX);
static tConfItem<REAL> bgy("BRAKE_GAUGE_LOCY",subby_BrakeGaugeLocY);

static REAL subby_RubberGaugeSize=.175, subby_RubberGaugeLocX=-0.48, subby_RubberGaugeLocY=-0.9;
static tConfItem<REAL> rgs("RUBBER_GAUGE_SIZE",subby_RubberGaugeSize);
static tConfItem<REAL> rgx("RUBBER_GAUGE_LOCX",subby_RubberGaugeLocX);
static tConfItem<REAL> rgy("RUBBER_GAUGE_LOCY",subby_RubberGaugeLocY);

static bool subby_ShowHUD=true, subby_ShowSpeedFastest=true, subby_ShowScore=true, subby_ShowAliveEnemies=true, subby_ShowPing=true;
static tConfItem<bool> showh("SHOW_HUD",subby_ShowHUD);
static tConfItem<bool> showf("SHOW_FASTEST",subby_ShowSpeedFastest);
static tConfItem<bool> shows("SHOW_SCORE",subby_ShowScore);
static tConfItem<bool> showae("SHOW_ENEMIES",subby_ShowAliveEnemies);
static tConfItem<bool> showp("SHOW_PING",subby_ShowPing);

static REAL subby_ScoreLocX=-0.95, subby_ScoreLocY=-0.85, subby_ScoreSize =.13;
static tConfItem<REAL> scorex("SCORE_LOCX",subby_ScoreLocX);
static tConfItem<REAL> scorey("SCORE_LOCY",subby_ScoreLocY);
static tConfItem<REAL> scores("SCORE_SIZE",subby_ScoreSize);

static REAL subby_FastestLocX=-0.0, subby_FastestLocY=-0.95, subby_FastestSize =.12;
static tConfItem<REAL> fastx("FASTEST_LOCX",subby_FastestLocX);
static tConfItem<REAL> fasty("FASTEST_LOCY",subby_FastestLocY);
static tConfItem<REAL> fasts("FASTEST_SIZE",subby_FastestSize);

static REAL subby_AliveEnemiesLocX=.5, subby_AliveEnemiesLocY=-0.95, subby_AliveEnemiesSize =.13;
static tConfItem<REAL> aex("ENEMIES_LOCX",subby_AliveEnemiesLocX);
static tConfItem<REAL> aey("ENEMIES_LOCY",subby_AliveEnemiesLocY);
static tConfItem<REAL> aes("ENEMIES_SIZE",subby_AliveEnemiesSize);

static REAL subby_PingLocX=.80, subby_PingLocY=-0.95, subby_PingSize =.13;
static tConfItem<REAL> px("PING_LOCX",subby_PingLocX);
static tConfItem<REAL> py("PING_LOCY",subby_PingLocY);
static tConfItem<REAL> ps("PING_SIZE",subby_PingSize);

static tConfItem<int>   tm0("TEXTURE_MODE_0",TextureMode[0]);
static tConfItem<int>   tm1("TEXTURE_MODE_1",TextureMode[1]);
static tConfItem<int>   tm2("TEXTURE_MODE_2",TextureMode[2]);
static tConfItem<int>   tm3("TEXTURE_MODE_3",TextureMode[3]);



uMenu sg_screenMenu("$display_settings_menu");

static uMenuItemFunction defaul
(&sg_screenMenu,"$graphics_load_defaults_text",
 "$graphics_load_defaults_help",
&sr_LoadDefaultConfig);
uMenu screen_menu_detail("$detail_settings_menu");
uMenu screen_menu_tweaks("$performance_tweaks_menu");
uMenu screen_menu_mode("$screen_mode_menu");
uMenu screen_menu_prefs("$preferences_menu");

static uMenuItemSubmenu smt(&sg_screenMenu,&screen_menu_tweaks,
			    "$performance_tweaks_menu_help");
static uMenuItemSubmenu smd(&sg_screenMenu,&screen_menu_detail,
			    "$detail_settings_menu_help");
static uMenuItemSubmenu smp(&sg_screenMenu,&screen_menu_prefs,
			    "$preferences_menu_help");
static uMenuItemSubmenu smm(&sg_screenMenu,&screen_menu_mode,
			    "$screen_mode_menu_help");


static tConfItemLine c_ext("GL_EXTENSIONS",gl_extensions);
static tConfItemLine c_ver("GL_VERSION",gl_version);
static tConfItemLine c_rEnd("GL_RENDERER",gl_renderer);
static tConfItemLine c_vEnd("GL_VENDOR",gl_vendor);
// static tConfItemLine a_ver("ARMAGETRON_VERSION",sn_programVersion);
static tConfItemLine a_mod_1("MESSAGE_OF_DAY_1",sn_greeting[0]);
static tConfItemLine a_mod_2("MESSAGE_OF_DAY_2",sn_greeting[1]);
static tConfItemLine a_mod_3("MESSAGE_OF_DAY_3",sn_greeting[2]);
static tConfItemLine a_mod_4("MESSAGE_OF_DAY_4",sn_greeting[3]);
static tConfItemLine a_mod_5("MESSAGE_OF_DAY_5",sn_greeting[4]);

class ArmageTron_feature_menuitem: public uMenuItemSelection<int>{
  void NewChoice(uSelectItem<bool> *){};
  void NewChoice(char *,bool ){};
public:
  ArmageTron_feature_menuitem(uMenu *m,char *tit,const char *help,int &targ)
    :uMenuItemSelection<int>(m,tit,help,targ){
    uMenuItemSelection<int>::NewChoice(
				       "$feature_disabled_text",
				       "$feature_disabled_help",
				       rFEAT_OFF);
    uMenuItemSelection<int>::NewChoice(
				       "$feature_default_text",
				       "$feature_default_help",
				       rFEAT_DEFAULT);
    uMenuItemSelection<int>::NewChoice(
				       "$feature_enabled_text",
				       "$feature_enabled_help",
				       rFEAT_ON);
  }

  ~ArmageTron_feature_menuitem(){};
};


class ArmageTron_texmode_menuitem: public uMenuItemSelection<int>{
  void NewChoice(uSelectItem<bool> *){};
  void NewChoice(char *,bool ){};
public:
  ArmageTron_texmode_menuitem(uMenu *m,char *tit,int &targ,
			      bool force=false)
    :uMenuItemSelection<int>
  (m,tit,"$texture_menuitem_help",targ){

    if(!force)
      uMenuItemSelection<int>::NewChoice
	("$texture_off_text","$texture_off_help",-1);
#ifndef DEDICATED
    uMenuItemSelection<int>::NewChoice
      ("$texture_nearest_text","$texture_nearest_help",GL_NEAREST);

    uMenuItemSelection<int>::NewChoice
      ("$texture_bilinear_text","$texture_bilinear_help",GL_LINEAR);

    uMenuItemSelection<int>::NewChoice
      ("$texture_mipmap_nearest_text",
       "$texture_mipmap_nearest_help",
       GL_NEAREST_MIPMAP_NEAREST);
    uMenuItemSelection<int>::NewChoice
      ("$texture_mipmap_bilinear_text",
       "$texture_mipmap_bilinear_help",
       GL_LINEAR_MIPMAP_NEAREST);
    uMenuItemSelection<int>::NewChoice
      ("$texture_mipmap_trilinear_text",
       "$texture_mipmap_trilinear_help",
       GL_LINEAR_MIPMAP_LINEAR);
    #endif
  }

  ~ArmageTron_texmode_menuitem(){};
};

static tConfItem<int>     la("LINE_ANTIALIAS",sr_lineAntialias);
static tConfItem<int>     pa("POLY_ANTIALIAS",sr_polygonAntialias);
static tConfItem<int>     pc("PERSP_CORRECT",sr_perspectiveCorrection);
static tConfItem<bool>    ab("ALPHA_BLEND",sr_alphaBlend);
static tConfItem<bool>    ss("SMOOTH_SHADING",sr_smoothShading);
static tConfItem<bool>    to("TEXT_OUT",sr_textOut);
static tConfItem<bool>    fps("SHOW_FPS",sr_FPSOut);
// tConfItem<> ("",&);
static tConfItem<int> fm("FLOOR_MIRROR",sr_floorMirror);
static tConfItem<int> fd("FLOOR_DETAIL",sr_floorDetail);
static tConfItem<bool> hr("HIGH_RIM",sr_highRim);
static tConfItem<bool> dt("DITHER",sr_dither);
static tConfItem<bool> us("UPPER_SKY",sr_upperSky);
static tConfItem<bool> ls("LOWER_SKY",sr_lowerSky);
static tConfItem<bool> wos("SKY_WOBBLE",sr_skyWobble);
static tConfItem<bool> ip("INFINITY_PLANE",sr_infinityPlane);

static tConfItem<bool> lm("LAG_O_METER",sr_laggometer);
static tConfItem<bool> po("PREDICT_OBJECTS",sr_predictObjects);
static tConfItem<bool> t32("TEXTURES_HI",sr_texturesTruecolor);



#ifndef SDL_OPENGL
#ifndef DIRTY
#define DIRTY
#endif
#endif

static uMenuItemFunction appl
(&screen_menu_mode,
 "$screen_apply_changes_text",
 "$screen_apply_changes_help",
 &sr_ReinitDisplay);

static uMenuItemToggle ie_t
(&screen_menu_mode,
 "$screen_check_errors_text",
 "$screen_check_errors_help",
 currentScreensetting.checkErrors);


#ifdef SDL_OPENGL
#ifdef DIRTY
static uMenuItemToggle sdl_t
(&screen_menu_mode,
 "$screen_use_sdl_text",
 "$screen_use_sdl_help",
 currentScreensetting.useSDL);
#endif
#endif

static uMenuItemToggle gm(
			  &screen_menu_mode,
			  "$screen_grab_mouse_text",
			  "$screen_grab_mouse_help",
			  su_mouseGrab);

static uMenuItemSelection<rColorDepth> zd_t
(&screen_menu_mode,
 "$screen_zdepth_text",
 "$screen_zdepth_help",
 currentScreensetting.zDepth);

static uSelectEntry<rColorDepth> zd_16(zd_t,"$screen_zdepth_16_text","$screen_zdepth_16_help",ArmageTron_ColorDepth_16);
static uSelectEntry<rColorDepth> zd_d(zd_t,"$screen_zdepth_desk_text","$screen_zdepth_desk_help",ArmageTron_ColorDepth_Desktop);
static uSelectEntry<rColorDepth> zd_32(zd_t,"$screen_zdepth_32_text","$screen_zdepth_32_help",ArmageTron_ColorDepth_32);

static uMenuItemSelection<rColorDepth> cd_t
(&screen_menu_mode,
 "$screen_colordepth_text",
 "$screen_colordepth_help",
 currentScreensetting.colorDepth);

static uSelectEntry<rColorDepth> cd_16(cd_t,"$screen_colordepth_16_text","$screen_colordepth_16_help",ArmageTron_ColorDepth_16);
static uSelectEntry<rColorDepth> cd_d(cd_t,"$screen_colordepth_desk_text","$screen_colordepth_desk_help",ArmageTron_ColorDepth_Desktop);
static uSelectEntry<rColorDepth> cd_32(cd_t,"$screen_colordepth_32_text","$screen_colordepth_32_help",ArmageTron_ColorDepth_32);

static uMenuItemToggle fs_t
(&screen_menu_mode,
 "$screen_fullscreen_text",
 "$screen_fullscreen_help",
 currentScreensetting.fullscreen);


class gResMenEntry
{
uMenuItemSelection<rResolution> res_men;
uSelectEntry<rResolution> a;
uSelectEntry<rResolution> b;
uSelectEntry<rResolution> c;
uSelectEntry<rResolution> d;
uSelectEntry<rResolution> e;
uSelectEntry<rResolution> f;
uSelectEntry<rResolution> g;
uSelectEntry<rResolution> gg;
uSelectEntry<rResolution> h;
uSelectEntry<rResolution> i;
uSelectEntry<rResolution> ii;
uSelectEntry<rResolution> j;
uSelectEntry<rResolution> jj;

public:
	gResMenEntry( rResolution& res, const tOutput& text, const tOutput& help )
:res_men
(&screen_menu_mode,
 text,
 help,
 res),
 a(res_men,"320x200","",ArmageTron_320_200),
 b(res_men,"320x240","",ArmageTron_320_240),
 c(res_men,"400x300","",ArmageTron_400_300),
 d(res_men,"512x384","",ArmageTron_512_384),
 e(res_men,"640x480","",ArmageTron_640_480),
 f(res_men,"800x600","",ArmageTron_800_600),
 g(res_men,"1024x768","",ArmageTron_1024_768),
 gg(res_men,"1280x854","",ArmageTron_1280_854),
 h(res_men,"1280x1024","",ArmageTron_1280_1024),
 i(res_men,"1600x1200","",ArmageTron_1600_1200),
 ii(res_men,"1680x1050","",ArmageTron_1680_1050),
 j(res_men,"2048x1572","",ArmageTron_2048_1572),
 jj(res_men,
				    "$screen_custom_text",
				    "$screen_custom_help"
				    ,ArmageTron_Custom)
	{
		
	}
};

static gResMenEntry res( currentScreensetting.res, "$screen_resolution_text", "$screen_resolution_help" );
static gResMenEntry winsize( currentScreensetting.windowSize, "$window_size_text", "$window_size_help" );

/*
uMenuItemSelection<rResolution> res_men
(&screen_menu_mode,
 "$screen_resolution_text",
 "$screen_resolution_help",
 currentScreensetting.res);


uSelectEntry<rResolution> a(res_men,"320x200","",ArmageTron_320_200);
 static uSelectEntry<rResolution> b(res_men,"320x240","",ArmageTron_320_240);
static uSelectEntry<rResolution> c(res_men,"400x300","",ArmageTron_400_300);
static uSelectEntry<rResolution> d(res_men,"512x384","",ArmageTron_512_384);
static uSelectEntry<rResolution> e(res_men,"640x480","",ArmageTron_640_480);
static uSelectEntry<rResolution> f(res_men,"800x600","",ArmageTron_800_600);
static uSelectEntry<rResolution> g(res_men,"1024x768","",ArmageTron_1024_768);
static uSelectEntry<rResolution> h(res_men,"1280x1024","",ArmageTron_1280_1024);
static uSelectEntry<rResolution> i(res_men,"1600x1200","",ArmageTron_1600_1200);
static uSelectEntry<rResolution> j(res_men,"2048x1572","",ArmageTron_2048_1572);
static uSelectEntry<rResolution> jj(res_men,
				    "$screen_custom_text",
				    "$screen_custom_help"
				    ,ArmageTron_Custom);
*/

static uMenuItemSelection<int> mfm
(&screen_menu_detail,
 "$detail_floor_mirror_text",
 "$detail_floor_mirror_help",
sr_floorMirror);
static uSelectEntry<int> mfma(mfm,"$detail_floor_mirror_off_text","$detail_floor_mirror_off_help",rMIRROR_OFF);


static uSelectEntry<int> mfmb(mfm,"$detail_floor_mirror_obj_text",
			      "$detail_floor_mirror_obj_help",
			      rMIRROR_OBJECTS);

static uSelectEntry<int> mfmc(mfm,"$detail_floor_mirror_ow_text",
			      "$detail_floor_mirror_ow_help",
			      rMIRROR_WALLS);

static uSelectEntry<int> mfme(mfm,"$detail_floor_mirror_ev_text","$detail_floor_mirror_ev_help",rMIRROR_ALL);

static uMenuItemToggle fs_dither
(&screen_menu_detail,"$detail_dither_text",
"$detail_dither_help",
 sr_dither);

static uMenuItemSelection<int> mfd
(&screen_menu_detail,
 "$detail_floor_text",
 "$detail_floor_help",
sr_floorDetail);

static uSelectEntry<int> mfda(mfd,"$detail_floor_no_text",
			      "$detail_floor_no_help",
			      rFLOOR_OFF);
static uSelectEntry<int> mfdb(mfd,"$detail_floor_grid_text",
			      "$detail_floor_grid_help",
			      rFLOOR_GRID);
static uSelectEntry<int> mfdc(mfd,"$detail_floor_tex_text",
			      "$detail_floor_tex_help",
			      rFLOOR_TEXTURE);
static uSelectEntry<int> mfdd(mfd,"$detail_floor_2tex_text",
			      "$detail_floor_2tex_help",
			      rFLOOR_TWOTEXTURE);


static ArmageTron_feature_menuitem pam
(&screen_menu_detail,"$detail_polyantialias_text",
 "$detail_polyantialias_help",
 sr_polygonAntialias);

static ArmageTron_feature_menuitem lam
(&screen_menu_detail,"$detail_lineantialias_text",
"$detail_lineantialias_help",
sr_lineAntialias);

static uMenuItemToggle  abm
(&screen_menu_detail,"$detail_alpha_text",
"$detail_alpha_help",
sr_alphaBlend);

static uMenuItemToggle  ssm
(&screen_menu_detail,"$detail_smooth_text",
"$detail_smooth_help",
sr_smoothShading);

static ArmageTron_feature_menuitem pcm
(&screen_menu_detail,"$detail_persp_text",
"$detail_persp_help",
 sr_perspectiveCorrection);

extern bool crash_sparks;		// from gCycle.cpp
extern bool white_sparks;		// from gSparks.cpp
static tConfItem<bool> cs2("SPARKS",crash_sparks);
static tConfItem<bool> wsp("WHITE_SPARKS",white_sparks);

static uMenuItemToggle  t32b
(&screen_menu_detail,"$detail_text_truecolor_text",
"$detail_text_truecolor_help"
,sr_texturesTruecolor);


static ArmageTron_texmode_menuitem tmm0(&screen_menu_detail,
					TextureGroupDescription[0],
					TextureMode[0]);

static ArmageTron_texmode_menuitem tmm1(&screen_menu_detail,
					TextureGroupDescription[1],
					TextureMode[1]);

static ArmageTron_texmode_menuitem tmm2(&screen_menu_detail,
					TextureGroupDescription[2],
					TextureMode[2]);

static ArmageTron_texmode_menuitem tmm3(&screen_menu_detail,
					TextureGroupDescription[3],
					TextureMode[3],true);


static uMenuItemToggle s2
(&screen_menu_prefs,"$pref_highrim_text",
 "$pref_highrim_help",sr_highRim);

static uMenuItemToggle us2
(&screen_menu_prefs,"$pref_uppersky_text",
 "$pref_uppersky_help",
sr_upperSky);

static uMenuItemToggle ls2
(&screen_menu_prefs,"$pref_lowersky_text",
 "$pref_lowersky_help",
 sr_lowerSky);
 
uMenuItemToggle fps2
(&screen_menu_prefs,"$misc_fps_text",
"$misc_fps_help",sr_FPSOut); 


 uMenuItemToggle hud3
(&screen_menu_prefs,"$pref_showfastest_text",
"$pref_showfastest_help",subby_ShowSpeedFastest); 

 uMenuItemToggle mud4
(&screen_menu_prefs,"$pref_showscore_text",
"$pref_showscore_help",subby_ShowScore); 

 uMenuItemToggle hud5
(&screen_menu_prefs,"$pref_showenemies_text",
"$pref_showenemies_help",subby_ShowAliveEnemies); 

 uMenuItemToggle hud6
(&screen_menu_prefs,"$pref_showping_text",
"$pref_showping_help",subby_ShowPing); 

uMenuItemToggle hud2
(&screen_menu_prefs,"$pref_showhud_text",
"$pref_showhud_help",subby_ShowHUD); 

static uMenuItemToggle ws2
(&screen_menu_prefs,"$pref_skymove_text",
 "$pref_skymove_help",
 sr_skyWobble);

static uMenuItemToggle cs
(&screen_menu_prefs,"$pref_sparks_text",
 "$pref_sparks_help",
 crash_sparks);

static uMenuItemToggle dl
(&screen_menu_tweaks,"$tweaks_displaylists_text",
 "$tweaks_displaylists_help", rModel::useDisplayLists);

static uMenuItemToggle zt
(&screen_menu_tweaks,"$tweaks_ztrick_text",
 "$tweaks_ztrick_help",sr_ZTrick);

static uMenuItemToggle infp
(&screen_menu_tweaks,"$tweaks_infinity_text",
"$tweaks_infinity_help" 
,sr_infinityPlane);





static tConfItem<bool> WRAP("WRAP_MENU",uMenu::wrap);



#ifndef DEDICATED

class gMemuItemConsole: uMenuItemString{
public:
  gMemuItemConsole(uMenu *M,tString &c):
    uMenuItemString(M,"Con:","",c){}

  virtual ~gMemuItemConsole(){}

  //virtual void Render(REAL x,REAL y,REAL alpha=1,bool selected=0);

  virtual bool Event(SDL_Event &e){
    if (e.type==SDL_KEYDOWN && 
	(e.key.keysym.sym==SDLK_KP_ENTER || e.key.keysym.sym==SDLK_RETURN)){

      con << ColorString(.5,.5,1) << " > " << *content << '\n';
      std::stringstream s(&((*content)[0]));
      tConfItemBase::LoadAll(s);
      
      MyMenu()->Exit();
      return true;
    }
    else if (e.type==SDL_KEYDOWN && 
	     uActionGlobal::IsBreakingGlobalBind(e.key.keysym.sym))
      return su_HandleEvent(e, true);
    else
      return uMenuItemString::Event(e);
  }
};

void do_con(){
  se_ChatState( ePlayerNetID::ChatFlags_Console, true );
  sr_con.SetHeight(20,false);
  se_SetShowScoresAuto(false);
  tString c;
  
  uMenu con_menu("",false);
  gMemuItemConsole s(&con_menu,c);
  con_menu.SetCenter(-.75);
  con_menu.SetBot(-2);
  con_menu.SetTop(-.7);
  con_menu.Enter();
  
  se_ChatState( ePlayerNetID::ChatFlags_Console, false );
  
  se_SetShowScoresAuto(true);
  sr_con.SetHeight(7,false);
}
#endif

void sg_ConsoleInput(){
#ifndef DEDICATED
  st_ToDo(&do_con);
#endif
}















class ArmageTron_viewport_menuitem:public uMenuItemInt{
public:
  ArmageTron_viewport_menuitem(uMenu *m):
    uMenuItemInt(m,"$viewport_menu_title",
		 "$viewport_menu_help",
		 rViewportConfiguration::next_conf_num,
		 0,rViewportConfiguration::s_viewportNumConfigurations-1){
    m->RequestSpaceBelow(.9);
  }

  virtual REAL SpaceRight(){return 1;}

  virtual void RenderBackground(){
    uMenuItem::RenderBackground();

    if (rViewportConfiguration::next_conf_num<0) rViewportConfiguration::next_conf_num=0;
    if (rViewportConfiguration::next_conf_num>=rViewportConfiguration::s_viewportNumConfigurations) 
      rViewportConfiguration::next_conf_num=rViewportConfiguration::s_viewportNumConfigurations-1;
    
    tString  titles[MAX_VIEWPORTS];
    
    for(int i=MAX_VIEWPORTS-1;i>=0;i--)
      titles[i] << i+1;
#ifndef DEDICATED
    rViewportConfiguration::DemonstrateViewport(titles);
#endif
  }

  virtual void Render(REAL x,REAL y,REAL alpha=1,bool selected=0){
    if (rViewportConfiguration::next_conf_num<0) rViewportConfiguration::next_conf_num=0;
    if (rViewportConfiguration::next_conf_num>=rViewportConfiguration::s_viewportNumConfigurations) 
      rViewportConfiguration::next_conf_num=rViewportConfiguration::s_viewportNumConfigurations-1;

    tOutput disp;
    
    disp << "$viewport_conf_text"; 
    disp.AddSpace();
    disp << rViewportConfiguration::s_viewportConfigurationNames[rViewportConfiguration::next_conf_num];
    DisplayText(x-.02,y,disp,selected,alpha);
  }
  
};



class ArmageTronPlayer_to_viewport_menuitem:public uMenuItemInt{
  int    vp;
public:
  ArmageTronPlayer_to_viewport_menuitem(uMenu *m,int v):
    uMenuItemInt(m,"",
		 "$viewport_assign_help",
		 s_newViewportBelongsToPlayer[v],
		 0,MAX_PLAYERS-1),vp(v){
    m->RequestSpaceBelow(.9);
  }

  virtual REAL SpaceRight(){return 1;}

  virtual void LeftRight(int x){
    rViewport::SetDirectionOfCorrection(vp,x);
    target=(target + MAX_PLAYERS + x) % MAX_PLAYERS;
  }

  virtual void RenderBackground(){
    rViewport::CorrectViewport(vp, MAX_PLAYERS);

    uMenuItem::RenderBackground();
    
    tString titles[MAX_VIEWPORTS];
    for(int i=MAX_VIEWPORTS-1;i>=0;i--){
      titles[i] << s_newViewportBelongsToPlayer[i]+1;
      titles[i] << " (";
      titles[i] << ePlayer::PlayerConfig(s_newViewportBelongsToPlayer[i])->Name();
      titles[i] << ")";
    }
#ifndef DEDICATED
    rViewportConfiguration::DemonstrateViewport(titles);
#endif
  }
  
  virtual void Render(REAL x,REAL y,REAL alpha=1,bool selected=0){

    tOutput disp;
    
    disp.SetTemplateParameter(1, vp +1);
    disp.SetTemplateParameter(2, s_newViewportBelongsToPlayer[vp]+1);
    disp.SetTemplateParameter(3, ePlayer::PlayerConfig(s_newViewportBelongsToPlayer[vp])->Name());
    disp << "$viewport_belongs_text";

    DisplayText(x-.02,y,disp,selected,alpha);
  }
  
};

#include "rSysdep.h"
extern void Render(int);


class ArmageTron_color_menuitem:public uMenuItemInt{
protected:
  int *rgb;
  unsigned short me;
public:
  ArmageTron_color_menuitem(uMenu *m,const char *tit,
			    const char *help, int *RGB,int Me)
    :uMenuItemInt(m,tit,help,RGB[Me],0,15),
     rgb(RGB),me(Me) {
    m->RequestSpaceBelow(.2);
  }

  ~ArmageTron_color_menuitem(){};

  virtual REAL SpaceRight(){return .2;}


  virtual void RenderBackground(){
    //    static int count=0;
    /*
    while(rgb[0]+rgb[1]+rgb[2]<13){
      if (rgb[count]<15)
	rgb[count]++;
      count++;
      if (count>2)
	count=0;
    }
    */
#ifndef DEDICATED
    if (!sr_glOut)
      return;
    uMenuItem::RenderBackground();
    REAL r = rgb[0]/15.0;
    REAL g = rgb[1]/15.0;
    REAL b = rgb[2]/15.0;
    se_MakeColorValid(r, g, b, 1.0f);
    glColor3f(r, g, b);
    glRectf(.8,-.8,.98,-.98);
#endif
  }

};



void sg_PlayerMenu(int Player){
  tOutput name;
     name.SetTemplateParameter(1, Player+1);
  
     name << "$player_menu_text";
  
 
  uMenu playerMenu(name);

  uMenu camera_menu("$player_camera_text");
  uMenu chat_menu("$player_chat_text");
  //  name.Clear();

  uMenuItemString *ic[MAX_INSTANT_CHAT];

  ePlayer *p = ePlayer::PlayerConfig(Player);
  if (!p)
    return;

  int i;
  for(i=MAX_INSTANT_CHAT-1;i>=0;i--){
    tOutput name;
    name.SetTemplateParameter(1, i+1);
    name << "$player_chat_chat";
    ic[i]=new uMenuItemString
      (&chat_menu,name,
       "$player_chat_chat_help",
       p->instantChatString[i], se_SpamMaxLen);
  }


  uMenuItemToggle sp
    (&playerMenu,"$player_spectator_text",
     "$player_spectator_help",
     p->spectate);

  uMenuItemToggle pnt
    (&playerMenu,"$player_name_team_text",
     "$player_name_team_help",
     p->nameTeamAfterMe);

  uMenuItemInt npt
    (&playerMenu,"$player_num_per_team_text",
     "$player_num_per_team_help",
     p->favoriteNumberOfPlayersPerTeam, 1, 16, 1);

  ArmageTron_color_menuitem B(&playerMenu,"$player_blue_text",
				"$player_blue_help",
				p->rgb,2);

  ArmageTron_color_menuitem G(&playerMenu,"$player_green_text",
				"$player_green_help",
				p->rgb,1);

  ArmageTron_color_menuitem R(&playerMenu,"$player_red_text",
				"$player_red_help",
				p->rgb,0);



  uMenuItemSubmenu chm(&playerMenu,&chat_menu,
				 "$player_chat_chat_help");
  
  uMenuItemSubmenu cm(&playerMenu,&camera_menu,
				 "$player_camera_help");

  uMenuItemFunctionInt icc(&playerMenu,"$player_camera_input_text",
				     "$player_camera_input_help",
				     &su_InputConfigCamera,Player);

  uMenuItemFunctionInt inc(&playerMenu,"$player_input_text",
				     "$player_input_help",
				     &su_InputConfig,Player);


  camera_menu.SetCenter(.3);


  uMenuItemToggle cis(&camera_menu,
				 "$player_camera_autoin_text",
				 "$player_camera_autoin_help",
				 p->autoSwitchIncam);

  uMenuItemToggle cim(&camera_menu,
				 "$player_camera_wobble_text",
				 "$player_camera_wobble_help",
				 p->wobbleIncam);

  uMenuItemToggle cic(&camera_menu,
		      "$player_camera_center_int_text",
		      "$player_camera_center_int_help",
		      p->centerIncamOnTurn);

  uMenuItemToggle al_s
    (&camera_menu,
     "$player_camera_smartcam_text",
     "$player_camera_smartcam_help",
     p->allowCam[CAMERA_SMART]);
  
  uMenuItemToggle al_f
    (&camera_menu,
     "$player_camera_fixed_text",
     "$player_camera_fixed_help",
     p->allowCam[CAMERA_FOLLOW]);
  

  uMenuItemToggle al_fr
    (&camera_menu,
     "$player_camera_free_text",
     "$player_camera_free_help",
     p->allowCam[CAMERA_FREE]);

  uMenuItemToggle al_c
    (&camera_menu,
     "$player_camera_custom_text",
     "$player_camera_custom_help",
     p->allowCam[CAMERA_CUSTOM]);
  
  uMenuItemToggle al_sc
    (&camera_menu,
     "$player_camera_server_custom_text",
     "$player_camera_server_custom_help",
     p->allowCam[CAMERA_SERVER_CUSTOM]);

  uMenuItemToggle al_i
    (&camera_menu,
     "$player_camera_incam_text",
     "$player_camera_incam_help",
     p->allowCam[CAMERA_IN]);


  uMenuItemInt cam_fov
    (&camera_menu,
     "$player_camera_fov_text",
     "$player_camera_fov_help",
     p->startFOV,30,120,5);

  uMenuItemSelection<eCamMode> cam_s
    (&camera_menu,
     "$player_camera_initial_text",
     "$player_camera_initial_help",
     p->startCamera);

  cam_s.NewChoice("$player_camera_initial_scust_text","$player_camera_initial_scust_help",CAMERA_SERVER_CUSTOM);
  cam_s.NewChoice("$player_camera_initial_cust_text","$player_camera_initial_cust_help",CAMERA_CUSTOM);
  cam_s.NewChoice("$player_camera_initial_int_text","$player_camera_initial_int_help",CAMERA_IN);
  cam_s.NewChoice("$player_camera_initial_smrt_text","$player_camera_initial_smrt_help",CAMERA_SMART);
  cam_s.NewChoice("$player_camera_initial_ext_text","$player_camera_initial_ext_help",CAMERA_FOLLOW);
  cam_s.NewChoice("$player_camera_initial_free_text","$player_camera_initial_free_help",CAMERA_FREE);

  tString dummy = p->name; // new methof... cause old one didnt work
  /* as soon as one puts any braces around a uMenu____ declaration, the menu item refuses to show.
     so now instead of hidding the name, we simply make an ingame chnage of name in the nmenu to a dummy variable that 
     gets reset after a change */
  
  
     uMenuItemString n(&playerMenu,
     "$player_name_text",
     "$player_name_help",
       globalingame?dummy:p->name, 16);
       
  dummy=p->name; // needs to be done again b/c Player 1 - 4 in p->name is not setup untill after the first call.
   
  
  playerMenu.Enter();

  for(i=MAX_INSTANT_CHAT-1; i>=0; i--)
    delete ic[i];

  // request network synchronisation
  ePlayerNetID::Update();

  for (i=MAX_PLAYERS-1; i>=0; i--)
    {
      if (ePlayer::PlayerIsInGame(i))
	{
	  ePlayer* p = ePlayer::PlayerConfig(i);
	  if (p->netPlayer)
	    p->netPlayer->RequestSync();
	}
    }
}


VOIDFUNC viewport_menu_x;






// from gGame.C
//extern int pingCharity;


void sg_PlayerMenu(){
  uMenu Player_men("$player_mainmenu_text");


  uMenuItemFunction vp_selec(&Player_men,
			     "$viewport_assign_text",
			     "$viewport_assign_help",
			     &viewport_menu_x);

  ArmageTron_viewport_menuitem vp(&Player_men);
  uMenuItemFunctionInt  *names[MAX_PLAYERS];

  int i;
  
  for(i=MAX_PLAYERS-1;i>=0;i--){
    tOutput title;
    title.SetTemplateParameter(1, i+1);
    title << "$player_menu_text";

    tOutput help;
    help.SetTemplateParameter(1, i+1);
    help << "$player_menu_help";

    names[i]=new uMenuItemFunctionInt(&Player_men,
				      title,
				      help,
				      sg_PlayerMenu,i);
  }

 
  Player_men.Enter();

  //  ePlayerNetID::Update();
  for(i=MAX_VIEWPORTS-1;i>=0;i--){
    delete names[i];
  }
}




void viewport_menu_x(void){
  uMenu sg_PlayerMenu("$viewport_assign_text");
  
  ArmageTronPlayer_to_viewport_menuitem *select[MAX_VIEWPORTS];

  int i;
  for(i=rViewportConfiguration::s_viewportConfigurations[rViewportConfiguration::next_conf_num]->num_viewports-1;i>=0;i--){
    select[i]=new ArmageTronPlayer_to_viewport_menuitem(&sg_PlayerMenu,i);
  }

  // ArmageTron_viewport_menuitem vp(&sg_PlayerMenu);
  
  sg_PlayerMenu.Enter();
 
  for(i=rViewportConfiguration::s_viewportConfigurations[rViewportConfiguration::next_conf_num]->num_viewports-1;i>=0;i--){
    delete select[i];
  }
}


static uActionGlobal con_input( "CONSOLE_INPUT" );


static uActionGlobal screenshot( "SCREENSHOT" );

static uActionGlobal togglefullscreen( "TOGGLE_FULLSCREEN" );


static bool screenshot_func(REAL x){
  if (x>0){
#ifndef DEDICATED
    sr_screenshotIsPlanned=true;
#endif
  }

  return true;
}

static bool con_func(REAL x){
  if (x>0){
    sg_ConsoleInput();
  }

  return true;
}

static bool toggle_fullscreen_func( REAL x )
{
	if ( x > 0 )
	{
		currentScreensetting.fullscreen = !currentScreensetting.fullscreen;
		sr_ReinitDisplay();
	}

	return true;	
}

static uActionGlobalFunc gaf_ss(&screenshot,&screenshot_func, true );
static uActionGlobalFunc gaf_md(&con_input,&con_func);
static uActionGlobalFunc gaf_tf(&togglefullscreen,&toggle_fullscreen_func, true );

#include <rRender.h>
#include <math.h>
#include "gCycle.h"
void GLmeter_subby(float value,float max, float locx, float locy, float size, tString title,bool displayvalue = true, bool reverse = false)
{
  sr_ResetRenderState(true); //needs this because rFont has bugs i presume.. Ie I have problems as soon as rTextFirld is used
  float x, y;
  char string[50];
  value>max?value=max:1;
  value<0?value=0:1;
  x= (reverse?-1:1) * cos(M_PI*value/max);
  y= sin(M_PI*value/max);
  if(y<size*.24) displayvalue = false; // dont display text when at minimum
  
  BeginLines();
  Color(.5,.5, 1);
  Vertex(-.1*x*size+locx,.1*y*size+locy,0);
  Vertex(-x*size+locx,y*size+locy,0);
  RenderEnd();


    rTextField min_t(-size-(0.1*size)+locx,locy,.12*size,.24*size);
    rTextField max_t(+size+(0.1*size)+locx,locy,.12*size,.24*size);
    min_t << "0xcccccc" << (reverse?max:0);
    max_t << "0xcccccc" << (reverse?0:max);

    if(displayvalue){
      rTextField speed_t(-x*1.45*size+locx,y*1.35*size+locy,.1*size,.2*size);
      sprintf(string,"%.1f",value);
      speed_t << "0xccffff" << (string);
    }
    int length = title.Len();
    rTextField titletext(locx-((.15*size*(length-1.5))/2.0),locy,.12*size,.24*size); //centre  -1.0 for null char and -.5 for half a char width = -1.5


    titletext << "0xff3333" << title;

#ifndef DEDICATED
    if (!sr_glOut)
      return;

    glColor3f(1,1,1);
#endif

}



static void tank_display_fps(){
  static int fps       = 60;
  static REAL lastTime = 0;

  if (se_mainGameTimer && 
      se_mainGameTimer->speed > .9 && 
      se_mainGameTimer->speed < 1.1)
    {
      REAL newtime = tSysTimeFloat();
      REAL ts      = newtime - lastTime;
      int newfps   = static_cast<int>(se_AverageFPS());
      if (fabs((newfps-fps)*ts)>4)
	{
	  fps      = newfps;
	  lastTime = newtime;
	}
      
      sr_ResetRenderState(true);
      Color(1,1,1);
      rTextField c(-.9,-.6);

	  tString name = uPlayerPrototype::PlayerConfig(0)->Name();
	  
	
	  signed short int playerID = -1;
//	  unsigned short int alivepeople2 = 0;
      unsigned short int max = se_PlayerNetIDs.Len();
//	  signed short int scores[16];
//	  signed short int teamID = -1;

	  //Find Player Name
	  if (se_PlayerNetIDs.Len()>0){
		for(unsigned short int i=0;i<se_PlayerNetIDs.Len();i++){
		  ePlayerNetID *p=se_PlayerNetIDs(i);
		  if (p->name == name){
			playerID = i;
			break;
		  }
		}
	  }

	  bool dohudcrap = false;
	  if (hudfpscount >= fps) {
		  hudfpscount = 0;
		  dohudcrap = true;
	  }
	  else { hudfpscount++; }

	  //Calculation, people alive
	if (dohudcrap) {
	  alivepeople=0;
	  for(unsigned short int i=0;i<max;i++){
	    ePlayerNetID *p=se_PlayerNetIDs(i);
	    if (p->Object() && p->Object()->Alive() && !(p->name == name)){
		  alivepeople++;
		}
	  }
	}

/*	  int max = teams.Len();
	  for(int i=0;i<max;i++){
	    eTeam *t = teams(i);
	  }*/

	  if (playerID > -1){
	      ePlayerNetID* p = se_PlayerNetIDs(playerID);
		  //Calculation, top player score
		  if (dohudcrap) {
	//	    unsigned short int maxscore = 0;
			thetopscore = 0;
			for(unsigned short int i=0;i<max;i++){
			  ePlayerNetID* p2=se_PlayerNetIDs(i);
		//	  if (p2->TotalScore() > p->TotalScore() || p2->TotalScore() > thetopscore){
			  if (p2->TotalScore() > thetopscore){
				thetopscore = p2->TotalScore();
			  }
			} 
		}

		  eCoord pcpos = (0,0);
		  if (p->Object() && p->Object()->Alive()) {
		    pcpos = p->Object()->Position(); }

		  tString line1, line2, line3;

	 /*    line1 << "HUD: " << p->name;
		  line1.SetPos(22, true);
          line1 << "FPS: " << fps;
		  line1.SetPos(34, true);
		  line1 << "ENEMIES: " << alivepeople << "\n";

	      line2 << "SCORE: " << p->TotalScore() << ", " << thetopscore;
		  line2.SetPos(22, true);
	      line2 << "PING: " << int(p->ping*1000) << "\n";

		  line3 << "LOCATION: " << int(pcpos.x);
		  line3 << ", " << int(pcpos.y);
		  line3.SetPos(22, true);
	     // line3 << "RUBBER: " << int(p->rubberstatus*100);

	
		 c <<line1 << line2; */


	  }
	}
}



static void display_fps_subby(){
  static int fps       = 60;
  static REAL lastTime = 0;

  if (se_mainGameTimer &&
      se_mainGameTimer->speed > .9 &&
      se_mainGameTimer->speed < 1.1)
    {
      REAL newtime = tSysTimeFloat();
      REAL ts      = newtime - lastTime;
      int newfps   = static_cast<int>(se_AverageFPS());
      if (fabs((newfps-fps)*ts)>4)
	{
	  fps      = newfps;
	  lastTime = newtime;
	}
     
      sr_ResetRenderState(true);
      Color(1,1,1);
      rTextField c(-.9,-.85);
      rTextField t(.6,.98);

      // t << "0xffffffGame Time:" << int (se_GameTime())<< " s";
       extern int globalnumviewports;
       
     if(subby_ShowHUD&&globalnumviewports==0){
       static int max=0,lastmax=0;
       static int imax=-1,lastimax=0;;
       REAL distance;
       static float maxmeterspeed= 50;
       float myping;
       static tString name;
       static tString ultiname;
       static bool  wrotefastest = false;
       static bool wrote10 =false;
       static bool belowzero=false;
       static REAL ultimax=0;
       static REAL timelast;
       static REAL myscore, topscore;
       tString myname = ePlayer::PlayerConfig(0)->Name();

      static bool firsttime =true;
     if(se_GameTime()<0||!firsttime){
       firsttime=false;
       if((se_GameTime()<0)){
            belowzero=true;
            if(se_GameTime()<-1){
                tOutput message;
              //  message<< "Last Game Fastest: " << name << " with a top speed of " << max << "\n";
              //  con << "testcon";
              //  sn_CenterMessage(message);
            }else{
                timelast = se_GameTime();
                max=0;
                wrotefastest = false;
                wrote10 =false;
            }
       }else if(se_GameTime()>0&&belowzero){
            belowzero=false;

       }

       topscore =0;
       for(int i =0 ; i< se_PlayerNetIDs.Len(); i++){
           ePlayerNetID *p = se_PlayerNetIDs[i];
      	   p->TotalScore()>topscore?topscore=p->TotalScore():1;
	            
           if(gCycle *h = (gCycle*)(p->Object())){
             //   distance = h->distance;
             //   c << p-> name << " " << int((h ->Speed())) << " "; 
                if (h->Speed()>max){
                    max =  (int) h->Speed();  //could be changed to float for more accuracy in reporting top speed
                    name = p->name;
                    imax = i;

                }
                if( h->Speed()>ultimax){
                  ultimax = (int) h->Speed();
                  ultiname = p->name;
                }
         
                if (p->name==myname&&!(p->IsChatting())&&se_GameTime()>-2){
		  h->Speed()>maxmeterspeed?maxmeterspeed+=10:1;
		  myscore=p->TotalScore();	
		  myping = p->ping;
                  GLmeter_subby(h->Speed(),maxmeterspeed,subby_SpeedGaugeLocX,subby_SpeedGaugeLocY,subby_SpeedGaugeSize,"Speed");  // easy to use configurable meters
		  GLmeter_subby(h->rubber*10,*globalcyclerubber*10,subby_RubberGaugeLocX,subby_RubberGaugeLocY,subby_RubberGaugeSize," Rubber Used");
	          GLmeter_subby(h->brakingReservoir, 1.0,subby_BrakeGaugeLocX,subby_BrakeGaugeLocY,subby_BrakeGaugeSize, " Brakes");
		
		//  bool displayfastest = true;// put into global, set via menusytem... subby to do.make sr_DISPLAYFASTESTout
                  
       	           if(subby_ShowSpeedFastest)
		   {    
		   	
		   	float size= subby_FastestSize;
		         tString message;
			 			 
			 message << "  Fastest: " << name <<" " << max;
			 message.RemoveHex(); //cheers tank;
			 int length = message.Len();
			 
			  rTextField speed_fastest(subby_FastestLocX-((.15*size*(length-1.5))/2.0),subby_FastestLocY,.15*size,.3*size);
                     /*   rTextField speed_fastest(.7-((.15*size*(length-1.5))/2.0),.65,.15*size,.3*size); */
		     	
      	    		  speed_fastest << "0xbf9d50" << message;
			 
                   
		                           
       	          }
		   if(subby_ShowScore){
  		     	tString colour;
      		 	if(myscore==topscore){
       				 colour = "0xff9d50";
  		     	}else if (myscore > topscore){
       				 colour = "0x11ff11";
       			}else{
       				 colour = "0x11ffff";
       			}
       
      		 	float size = subby_ScoreSize;
       			rTextField score(subby_ScoreLocX,subby_ScoreLocY,.15*size,.3*size);
       			score <<               " Scores \n";
      		 	score << "0xefefef" << "Me:  Top:\n";
       			score << colour << myscore << "     0xffff00" << topscore ;
       			}
       
       		    if(subby_ShowAliveEnemies){
       	  		tString message;
	 		 message << "Enemies Alive: " << alivepeople ;
	  		int length = message.Len();
	  		float size = subby_AliveEnemiesSize;
	  		rTextField enemies_alive(subby_AliveEnemiesLocX-((.15*size*(length-1.5))/2.0),subby_AliveEnemiesLocY,.15*size,.3*size);	
          		enemies_alive << "0xfefefe" << message;
       		    }
       
      		    if(subby_ShowPing){
         		tString message;
	  		message << "Ping: " << int(myping * 1000) << " ms" ;
	  		int length = message.Len();
	  		float size = subby_PingSize;
	 		rTextField ping(subby_PingLocX-((.15*size*(length-1.5))/2.0),subby_PingLocY,.15*size,.3*size);	
          		ping << "0xfefefe" << message;
       		    }
       
      		    if(sr_FPSOut){
          	 	float size =.15;
          	 	rTextField c2(.7,.85,.15*size, .3*size);
          		c2 << "0xffffffFPS: " <<fps;
       		    }
                }
	   }
       }
  
       
       
     }
    }
     
  }
  tank_display_fps(); // call tank's version
  
}

static rPerFrameTask dfps(&display_fps_subby);
